label variable hagege16 "Number of persons aged 16 or older"
label variable hagege18 "Number of persons aged 18 or older"
label variable hagele15 "Number of children aged 15 or younger"
label variable hagege15_17 "Number of children aged 15-17"
label variable hagege15_18 "Number of children aged 15-18"
label variable hagele17 "Number of children aged 17 or younger"
label variable hagele18 "Number of children aged 18 or younger"
label variable hnumbmths_c "Number of banking access methods (continuous)"
label variable hhsupwgt "Household supplement weight"
label variable hryear4 "Survey year"
label variable hsupwgtk "Household-level weight (1000s)"
label variable huse3ccfq "Nonbank check cashing, frequency of use in past 30 days"
label variable huse3mofq "Nonbank money order, frequency of use in past 30 days"
label variable huse3rmfq "Nonbank international remittance, frequency of use in past 30 days"
label variable occurnum "Person identifier"
label variable qstnum "Household identifier"
label variable prtage "Age of householder respondent"
label variable prpertyp "Type of person record (see codebook for base CPS)"
label variable perrp "Relationship to reference person (see codebook for base CPS)"
label variable hrintsta "Interview status (see codebook for base CPS)"
label variable hnumbmths_cv2 "Number of banking access methods (continuous)"
label variable huse12bnkrsnnum_c "Number of bank account transaction types (continuous)"
label variable huse12opsrsnnum_c "Number of nonbank online payment service transaction types (continuous)"
label variable huse12pprsnnum_c "Number of prepaid card transaction types (continuous)"
label variable huse12morsnnum_c "Number of nonbank money order transaction types (continuous)"
label variable huse12mtrsnnum_c "Number of nonbank money transfer service transaction types (continuous)"
label variable gereg "Geographic region"
label define  geregnl  1 "Northeast" 2 "Midwest" 3 "South" 4 "West"
label values  gereg "geregnl"
label variable gestfips "State"
label define  gestfipsnl  1 "AL" 2 "AK" 4 "AZ" 5 "AR" 6 "CA" 8 "CO" 9 "CT" 10 "DE" 11 "DC" 12 "FL" 13 "GA" 15 "HI" 16 "ID" 17 "IL" 18 "IN" 19 "IA" 20 "KS" 21 "KY" 22 "LA" 23 "ME" 24 "MD" 25 "MA" 26 "MI" 27 "MN" 28 "MS" 29 "MO" 30 "MT" 31 "NE" 32 "NV" 33 "NH" 34 "NJ" 35 "NM" 36 "NY" 37 "NC" 38 "ND" 39 "OH" 40 "OK" 41 "OR" 42 "PA" 44 "RI" 45 "SC" 46 "SD" 47 "TN" 48 "TX" 49 "UT" 50 "VT" 51 "VA" 53 "WA" 54 "WV" 55 "WI" 56 "WY"
label values  gestfips "gestfipsnl"
label variable msa13 "MSA"
label define  msa13nl  0 "Not in MSA or MSA code not reported" 10180 "Abilene, TX" 10420 "Akron, OH" 10500 "Albany, GA" 10540 "Albany, OR" 10580 "Albany-Schenectady-Troy, NY" 10740 "Albuquerque, NM" 10900 "Allentown-Bethlehem-Easton, PA-NJ" 11020 "Altoona, PA" 11100 "Amarillo, TX~" 11460 "Ann Arbor, MI" 11500 "Anniston-Oxford-Jacksonville, AL" 11540 "Appleton, WI" 11700 "Asheville, NC" 12020 "Athens-Clarke County, GA" 12060 "Atlanta-Sandy Springs-Roswell, GA~" 12100 "Atlantic City-Hammonton, NJ" 12220 "Auburn-Opelika, AL" 12260 "Augusta-Richmond County, GA-SC~" 12420 "Austin-Round Rock, TX" 12540 "Bakersfield, CA" 12580 "Baltimore-Columbia-Towson, MD" 12620 "Bangor, ME~" 12700 "Barnstable Town, MA~" 12940 "Baton Rouge, LA" 12980 "Battle Creek, MI" 13140 "Beaumont-Port Arthur, TX~" 13380 "Bellingham, WA" 13460 "Bend-Redmond, OR" 13740 "Billings, MT~" 13780 "Binghamton, NY" 13820 "Birmingham-Hoover, AL" 13980 "Blacksburg-Christiansburg-Radford, VA~" 14010 "Bloomington, IL~" 14020 "Bloomington, IN~" 14260 "Boise City, ID" 14460 "Boston-Cambridge-Newton, MA-NH~" 14500 "Boulder, CO" 14540 "Bowling Green, KY~" 14740 "Bremerton-Silverdale, WA" 14860 "Bridgeport-Stamford-Norwalk, CT~" 15180 "Brownsville-Harlingen, TX" 15380 "Buffalo-Cheektowaga-Niagara Falls, NY" 15500 "Burlington, NC" 15540 "Burlington-South Burlington, VT~" 15680 "California-Lexington Park, MD" 15940 "Canton-Massillon, OH" 15980 "Cape Coral-Fort Myers, FL" 16060 "Carbondale-Marion, IL~" 16300 "Cedar Rapids, IA" 16540 "Chambersburg-Waynesboro, PA" 16580 "Champaign-Urbana, IL" 16620 "Charleston, WV~" 16700 "Charleston-North Charleston, SC" 16740 "Charlotte-Concord-Gastonia, NC-SC~" 16820 "Charlottesville, VA~" 16860 "Chattanooga, TN-GA" 16980 "Chicago-Naperville-Elgin, IL-IN-WI" 17020 "Chico, CA" 17140 "Cincinnati, OH-KY-IN~" 17300 "Clarksville, TN-KY~" 17420 "Cleveland, TN" 17460 "Cleveland-Elyria, OH" 17660 "Coeur dAlene, ID" 17780 "College Station-Bryan, TX" 17820 "Colorado Springs, CO" 17860 "Columbia, MO~" 17900 "Columbia, SC" 17980 "Columbus, GA-AL" 18140 "Columbus, OH~" 18580 "Corpus Christi, TX" 18880 "Crestview-Fort Walton Beach-Destin, FL~" 19100 "Dallas-Fort Worth-Arlington, TX~" 19300 "Daphne-Fairhope-Foley, AL" 19340 "Davenport-Moline-Rock Island, IA-IL" 19380 "Dayton, OH~" 19460 "Decatur, AL" 19500 "Decatur, IL" 19660 "Deltona-Daytona Beach-Ormond Beach, FL~" 19740 "Denver-Aurora-Lakewood, CO" 19780 "Des Moines-West Des Moines, IA" 19820 "Detroit-Warren-Dearborn, MI" 20100 "Dover, DE" 20260 "Duluth, MN-WI" 20500 "Durham-Chapel Hill, NC" 20700 "East Stroudsburg, PA" 20740 "Eau Claire, WI" 20940 "El Centro, CA" 21140 "Elkhart-Goshen, IN" 21340 "El Paso, TX~" 21500 "Erie, PA" 21660 "Eugene, OR" 21780 "Evansville, IN-KY~" 22020 "Fargo, ND-MN" 22140 "Farmington, NM" 22180 "Fayetteville, NC" 22220 "Fayetteville-Springdale-Rogers, AR-MO" 22420 "Flint, MI" 22500 "Florence, SC" 22520 "Florence-Muscle Shoals, AL" 22660 "Fort Collins, CO" 22900 "Fort Smith, AR-OK~" 23060 "Fort Wayne, IN" 23420 "Fresno, CA" 23540 "Gainesville, FL" 23580 "Gainesville, GA" 24020 "Glens Falls, NY" 24140 "Goldsboro, NC" 24340 "Grand Rapids-Wyoming, MI~" 24540 "Greeley, CO" 24580 "Green Bay, WI" 24660 "Greensboro-High Point, NC" 24780 "Greenville, NC~" 24860 "Greenville-Anderson-Mauldin, SC~" 25060 "Gulfport-Biloxi-Pascagoula, MS~" 25180 "Hagerstown-Martinsburg, MD-WV~" 25260 "Hanford-Corcoran, CA" 25420 "Harrisburg-Carlisle, PA" 25500 "Harrisonburg, VA" 25540 "Hartford-West Hartford-East Hartford, CT~" 25860 "Hickory-Lenoir-Morganton, NC" 25940 "Hilton Head Island-Bluffton-Beaufort, SC" 26420 "Houston-The Woodlands-Sugar Land, TX~" 26580 "Huntington-Ashland, WV-KY-OH~" 26620 "Huntsville, AL" 26820 "Idaho Falls, ID~" 26900 "Indianapolis-Carmel-Anderson, IN~" 26980 "Iowa City, IA" 27100 "Jackson, MI" 27140 "Jackson, MS~" 27260 "Jacksonville, FL" 27340 "Jacksonville, NC" 27500 "Janesville-Beloit, WI" 27740 "Johnson City, TN" 27780 "Johnstown, PA" 27900 "Joplin, MO" 27980 "Kahului-Wailuku-Lahaina, HI~" 28020 "Kalamazoo-Portage, MI" 28100 "Kankakee, IL" 28140 "Kansas City, MO-KS~" 28420 "Kennewick-Richland, WA" 28660 "Killeen-Temple, TX" 28700 "Kingsport-Bristol-Bristol, TN-VA~" 28740 "Kingston, NY" 28940 "Knoxville, TN~" 29100 "La Crosse-Onalaska, WI-MN" 29180 "Lafayette, LA~" 29200 "Lafayette-West Lafayette, IN" 29340 "Lake Charles, LA" 29420 "Lake Havasu City-Kingman, AZ" 29460 "Lakeland-Winter Haven, FL" 29540 "Lancaster, PA" 29620 "Lansing-East Lansing, MI" 29700 "Laredo, TX" 29740 "Las Cruces, NM" 29820 "Las Vegas-Henderson-Paradise, NV" 29940 "Lawrence, KS" 30020 "Lawton, OK~" 30340 "Lewiston-Auburn, ME~" 30460 "Lexington-Fayette, KY" 30780 "Little Rock-North Little Rock-Conway, AR" 30980 "Longview, TX" 31080 "Los Angeles-Long Beach-Anaheim, CA" 31140 "Louisville/Jefferson County, KY-IN~" 31180 "Lubbock, TX~" 31340 "Lynchburg, VA" 31420 "Macon, GA" 31460 "Madera, CA" 31540 "Madison, WI~" 31700 "Manchester-Nashua, NH~" 32580 "McAllen-Edinburg-Mission, TX" 32780 "Medford, OR" 32820 "Memphis, TN-MS-AR~" 32900 "Merced, CA" 33100 "Miami-Fort Lauderdale-West Palm Beach, FL" 33140 "Michigan City-La Porte, IN" 33260 "Midland, TX~" 33340 "Milwaukee-Waukesha-West Allis, WI" 33460 "Minneapolis-St. Paul-Bloomington, MN-WI~" 33660 "Mobile, AL" 33700 "Modesto, CA" 33740 "Monroe, LA" 33780 "Monroe, MI" 33860 "Montgomery, AL" 34060 "Morgantown, WV" 34580 "Mount Vernon-Anacortes, WA" 34740 "Muskegon, MI" 34820 "Myrtle Beach-Conway-North Myrtle Beach, SC-NC~" 34900 "Napa, CA" 34940 "Naples-Immokalee-Marco Island, FL" 34980 "Nashville-Davidson-Murfreesboro-Franklin, TN~" 35300 "New Haven-Milford, CT~" 35380 "New Orleans-Metairie, LA~" 35620 "New York-Newark-Jersey City, NY-NJ-PA~" 35660 "Niles-Benton Harbor, MI" 35840 "North Port-Sarasota-Bradenton, FL" 35980 "Norwich-New London, CT~" 36100 "Ocala, FL" 36140 "Ocean City, NJ" 36220 "Odessa, TX" 36260 "Ogden-Clearfield, UT~" 36420 "Oklahoma City, OK" 36500 "Olympia-Tumwater, WA" 36540 "Omaha-Council Bluffs, NE-IA" 36740 "Orlando-Kissimmee-Sanford, FL" 36780 "Oshkosh-Neenah, WI" 37100 "Oxnard-Thousand Oaks-Ventura, CA" 37340 "Palm Bay-Melbourne-Titusville, FL" 37460 "Panama City, FL~" 37860 "Pensacola-Ferry Pass-Brent, FL" 37900 "Peoria, IL" 37980 "Philadelphia-Camden-Wilmington, PA-NJ-DE-MD" 38060 "Phoenix-Mesa-Scottsdale, AZ" 38220 "Pine Bluff, AR" 38300 "Pittsburgh, PA" 38860 "Portland-South Portland, ME~" 38900 "Portland-Vancouver-Hillsboro, OR-WA" 38940 "Port St. Lucie, FL" 39140 "Prescott, AZ" 39300 "Providence-Warwick, RI-MA~" 39340 "Provo-Orem, UT" 39380 "Pueblo, CO" 39460 "Punta Gorda, FL" 39540 "Racine, WI" 39580 "Raleigh, NC" 39740 "Reading, PA" 39820 "Redding, CA" 39900 "Reno, NV" 40060 "Richmond, VA~" 40140 "Riverside-San Bernardino-Ontario, CA" 40220 "Roanoke, VA" 40380 "Rochester, NY~" 40420 "Rockford, IL" 40900 "Sacramento-Roseville-Arden-Arcade, CA" 40980 "Saginaw, MI" 41060 "St. Cloud, MN" 41100 "St. George, UT" 41180 "St. Louis, MO-IL~" 41420 "Salem, OR" 41500 "Salinas, CA" 41540 "Salisbury, MD-DE~" 41620 "Salt Lake City, UT~" 41700 "San Antonio-New Braunfels, TX" 41740 "San Diego-Carlsbad, CA" 41860 "San Francisco-Oakland-Hayward, CA" 41940 "San Jose-Sunnyvale-Santa Clara, CA" 42020 "San Luis Obispo-Paso Robles-Arroyo Grande, CA" 42100 "Santa Cruz-Watsonville, CA" 42140 "Santa Fe, NM" 42200 "Santa Maria-Santa Barbara, CA" 42220 "Santa Rosa, CA" 42340 "Savannah, GA" 42540 "Scranton-Wilkes-Barre-Hazleton, PA" 42660 "Seattle-Tacoma-Bellevue, WA" 42680 "Sebastian-Vero Beach, FL" 43300 "Sherman-Denison, TX" 43340 "Shreveport-Bossier City, LA~" 43420 "Sierra Vista-Douglas, AZ" 43620 "Sioux Falls, SD" 43780 "South Bend-Mishawaka, IN-MI" 43900 "Spartanburg, SC~" 44060 "Spokane-Spokane Valley, WA~" 44100 "Springfield, IL" 44140 "Springfield, MA~" 44180 "Springfield, MO" 44220 "Springfield, OH" 44700 "Stockton-Lodi, CA" 45060 "Syracuse, NY" 45220 "Tallahassee, FL" 45300 "Tampa-St. Petersburg-Clearwater, FL" 45460 "Terre Haute, IN" 45780 "Toledo, OH~" 45820 "Topeka, KS" 45940 "Trenton, NJ" 46060 "Tucson, AZ" 46140 "Tulsa, OK" 46220 "Tuscaloosa, AL~" 46340 "Tyler, TX" 46520 "Urban Honolulu, HI" 46540 "Utica-Rome, NY" 46660 "Valdosta, GA" 46700 "Vallejo-Fairfield, CA" 47020 "Victoria, TX~" 47220 "Vineland-Bridgeton, NJ" 47260 "Virginia Beach-Norfolk-Newport News, VA-NC~" 47300 "Visalia-Porterville, CA" 47380 "Waco, TX~" 47580 "Warner Robins, GA~" 47900 "Washington-Arlington-Alexandria, DC-VA-MD-WV~" 47940 "Waterloo-Cedar Falls, IA" 48060 "Watertown-Fort Drum, NY" 48140 "Wausau, WI" 48620 "Wichita, KS~" 48660 "Wichita Falls, TX" 48700 "Williamsport, PA" 49020 "Winchester, VA-WV" 49180 "Winston-Salem, NC~" 49340 "Worcester, MA-CT~" 49420 "Yakima, WA" 49620 "York-Hanover, PA" 49660 "Youngstown-Warren-Boardman, OH-PA" 49740 "Yuma, AZ"
label values  msa13 "msa13nl"
label variable msa5yr13 "MSA 5-year (uses February 2013 MSA delineations)"
label define  msa5yr13nl  0 "Not in MSA or MSA code not reported" 10180 "Abilene, TX" 10420 "Akron, OH" 10500 "Albany, GA" 10540 "Albany, OR" 10580 "Albany-Schenectady-Troy, NY" 10740 "Albuquerque, NM" 10900 "Allentown-Bethlehem-Easton, PA-NJ" 11020 "Altoona, PA" 11100 "Amarillo, TX~" 11460 "Ann Arbor, MI" 11500 "Anniston-Oxford-Jacksonville, AL" 11540 "Appleton, WI" 11700 "Asheville, NC" 12020 "Athens-Clarke County, GA" 12060 "Atlanta-Sandy Springs-Roswell, GA~" 12100 "Atlantic City-Hammonton, NJ" 12220 "Auburn-Opelika, AL" 12260 "Augusta-Richmond County, GA-SC~" 12420 "Austin-Round Rock, TX" 12540 "Bakersfield, CA" 12580 "Baltimore-Columbia-Towson, MD" 12620 "Bangor, ME~" 12700 "Barnstable Town, MA~" 12940 "Baton Rouge, LA" 12980 "Battle Creek, MI" 13140 "Beaumont-Port Arthur, TX~" 13380 "Bellingham, WA" 13460 "Bend-Redmond, OR" 13740 "Billings, MT~" 13780 "Binghamton, NY" 13820 "Birmingham-Hoover, AL" 13980 "Blacksburg-Christiansburg-Radford, VA~" 14010 "Bloomington, IL~" 14020 "Bloomington, IN~" 14260 "Boise City, ID" 14460 "Boston-Cambridge-Newton, MA-NH~" 14500 "Boulder, CO" 14540 "Bowling Green, KY~" 14740 "Bremerton-Silverdale, WA" 14860 "Bridgeport-Stamford-Norwalk, CT~" 15180 "Brownsville-Harlingen, TX" 15380 "Buffalo-Cheektowaga-Niagara Falls, NY" 15500 "Burlington, NC" 15540 "Burlington-South Burlington, VT~" 15680 "California-Lexington Park, MD" 15940 "Canton-Massillon, OH" 15980 "Cape Coral-Fort Myers, FL" 16060 "Carbondale-Marion, IL~" 16300 "Cedar Rapids, IA" 16540 "Chambersburg-Waynesboro, PA" 16580 "Champaign-Urbana, IL" 16620 "Charleston, WV~" 16700 "Charleston-North Charleston, SC" 16740 "Charlotte-Concord-Gastonia, NC-SC~" 16820 "Charlottesville, VA~" 16860 "Chattanooga, TN-GA" 16980 "Chicago-Naperville-Elgin, IL-IN-WI" 17020 "Chico, CA" 17140 "Cincinnati, OH-KY-IN~" 17300 "Clarksville, TN-KY~" 17420 "Cleveland, TN" 17460 "Cleveland-Elyria, OH" 17660 "Coeur dAlene, ID" 17780 "College Station-Bryan, TX" 17820 "Colorado Springs, CO" 17860 "Columbia, MO~" 17900 "Columbia, SC" 17980 "Columbus, GA-AL" 18140 "Columbus, OH~" 18580 "Corpus Christi, TX" 18880 "Crestview-Fort Walton Beach-Destin, FL~" 19100 "Dallas-Fort Worth-Arlington, TX~" 19300 "Daphne-Fairhope-Foley, AL" 19340 "Davenport-Moline-Rock Island, IA-IL" 19380 "Dayton, OH~" 19460 "Decatur, AL" 19500 "Decatur, IL" 19660 "Deltona-Daytona Beach-Ormond Beach, FL~" 19740 "Denver-Aurora-Lakewood, CO" 19780 "Des Moines-West Des Moines, IA" 19820 "Detroit-Warren-Dearborn, MI" 20100 "Dover, DE" 20260 "Duluth, MN-WI" 20500 "Durham-Chapel Hill, NC" 20700 "East Stroudsburg, PA" 20740 "Eau Claire, WI" 20940 "El Centro, CA" 21140 "Elkhart-Goshen, IN" 21340 "El Paso, TX~" 21500 "Erie, PA" 21660 "Eugene, OR" 21780 "Evansville, IN-KY~" 22020 "Fargo, ND-MN" 22140 "Farmington, NM" 22180 "Fayetteville, NC" 22220 "Fayetteville-Springdale-Rogers, AR-MO" 22420 "Flint, MI" 22500 "Florence, SC" 22520 "Florence-Muscle Shoals, AL" 22660 "Fort Collins, CO" 22900 "Fort Smith, AR-OK~" 23060 "Fort Wayne, IN" 23420 "Fresno, CA" 23540 "Gainesville, FL" 23580 "Gainesville, GA" 24020 "Glens Falls, NY" 24140 "Goldsboro, NC" 24340 "Grand Rapids-Wyoming, MI~" 24540 "Greeley, CO" 24580 "Green Bay, WI" 24660 "Greensboro-High Point, NC" 24780 "Greenville, NC~" 24860 "Greenville-Anderson-Mauldin, SC~" 25060 "Gulfport-Biloxi-Pascagoula, MS~" 25180 "Hagerstown-Martinsburg, MD-WV~" 25260 "Hanford-Corcoran, CA" 25420 "Harrisburg-Carlisle, PA" 25500 "Harrisonburg, VA" 25540 "Hartford-West Hartford-East Hartford, CT~" 25860 "Hickory-Lenoir-Morganton, NC" 25940 "Hilton Head Island-Bluffton-Beaufort, SC" 26420 "Houston-The Woodlands-Sugar Land, TX~" 26580 "Huntington-Ashland, WV-KY-OH~" 26620 "Huntsville, AL" 26820 "Idaho Falls, ID~" 26900 "Indianapolis-Carmel-Anderson, IN~" 26980 "Iowa City, IA" 27100 "Jackson, MI" 27140 "Jackson, MS~" 27260 "Jacksonville, FL" 27340 "Jacksonville, NC" 27500 "Janesville-Beloit, WI" 27740 "Johnson City, TN" 27780 "Johnstown, PA" 27900 "Joplin, MO" 27980 "Kahului-Wailuku-Lahaina, HI~" 28020 "Kalamazoo-Portage, MI" 28100 "Kankakee, IL" 28140 "Kansas City, MO-KS~" 28420 "Kennewick-Richland, WA" 28660 "Killeen-Temple, TX" 28700 "Kingsport-Bristol-Bristol, TN-VA~" 28740 "Kingston, NY" 28940 "Knoxville, TN~" 29100 "La Crosse-Onalaska, WI-MN" 29180 "Lafayette, LA~" 29200 "Lafayette-West Lafayette, IN" 29340 "Lake Charles, LA" 29420 "Lake Havasu City-Kingman, AZ" 29460 "Lakeland-Winter Haven, FL" 29540 "Lancaster, PA" 29620 "Lansing-East Lansing, MI" 29700 "Laredo, TX" 29740 "Las Cruces, NM" 29820 "Las Vegas-Henderson-Paradise, NV" 29940 "Lawrence, KS" 30020 "Lawton, OK~" 30340 "Lewiston-Auburn, ME~" 30460 "Lexington-Fayette, KY" 30780 "Little Rock-North Little Rock-Conway, AR" 30980 "Longview, TX" 31080 "Los Angeles-Long Beach-Anaheim, CA" 31140 "Louisville/Jefferson County, KY-IN~" 31180 "Lubbock, TX~" 31340 "Lynchburg, VA" 31420 "Macon, GA" 31460 "Madera, CA" 31540 "Madison, WI~" 31700 "Manchester-Nashua, NH~" 32580 "McAllen-Edinburg-Mission, TX" 32780 "Medford, OR" 32820 "Memphis, TN-MS-AR~" 32900 "Merced, CA" 33100 "Miami-Fort Lauderdale-West Palm Beach, FL" 33140 "Michigan City-La Porte, IN" 33260 "Midland, TX~" 33340 "Milwaukee-Waukesha-West Allis, WI" 33460 "Minneapolis-St. Paul-Bloomington, MN-WI~" 33660 "Mobile, AL" 33700 "Modesto, CA" 33740 "Monroe, LA" 33780 "Monroe, MI" 33860 "Montgomery, AL" 34060 "Morgantown, WV" 34580 "Mount Vernon-Anacortes, WA" 34740 "Muskegon, MI" 34820 "Myrtle Beach-Conway-North Myrtle Beach, SC-NC~" 34900 "Napa, CA" 34940 "Naples-Immokalee-Marco Island, FL" 34980 "Nashville-Davidson-Murfreesboro-Franklin, TN~" 35300 "New Haven-Milford, CT~" 35380 "New Orleans-Metairie, LA~" 35620 "New York-Newark-Jersey City, NY-NJ-PA~" 35660 "Niles-Benton Harbor, MI" 35840 "North Port-Sarasota-Bradenton, FL" 35980 "Norwich-New London, CT~" 36100 "Ocala, FL" 36140 "Ocean City, NJ" 36220 "Odessa, TX" 36260 "Ogden-Clearfield, UT~" 36420 "Oklahoma City, OK" 36500 "Olympia-Tumwater, WA" 36540 "Omaha-Council Bluffs, NE-IA" 36740 "Orlando-Kissimmee-Sanford, FL" 36780 "Oshkosh-Neenah, WI" 37100 "Oxnard-Thousand Oaks-Ventura, CA" 37340 "Palm Bay-Melbourne-Titusville, FL" 37460 "Panama City, FL~" 37860 "Pensacola-Ferry Pass-Brent, FL" 37900 "Peoria, IL" 37980 "Philadelphia-Camden-Wilmington, PA-NJ-DE-MD" 38060 "Phoenix-Mesa-Scottsdale, AZ" 38220 "Pine Bluff, AR" 38300 "Pittsburgh, PA" 38860 "Portland-South Portland, ME~" 38900 "Portland-Vancouver-Hillsboro, OR-WA" 38940 "Port St. Lucie, FL" 39140 "Prescott, AZ" 39300 "Providence-Warwick, RI-MA~" 39340 "Provo-Orem, UT" 39380 "Pueblo, CO" 39460 "Punta Gorda, FL" 39540 "Racine, WI" 39580 "Raleigh, NC" 39740 "Reading, PA" 39820 "Redding, CA" 39900 "Reno, NV" 40060 "Richmond, VA~" 40140 "Riverside-San Bernardino-Ontario, CA" 40220 "Roanoke, VA" 40380 "Rochester, NY~" 40420 "Rockford, IL" 40900 "Sacramento-Roseville-Arden-Arcade, CA" 40980 "Saginaw, MI" 41060 "St. Cloud, MN" 41100 "St. George, UT" 41180 "St. Louis, MO-IL~" 41420 "Salem, OR" 41500 "Salinas, CA" 41540 "Salisbury, MD-DE~" 41620 "Salt Lake City, UT~" 41700 "San Antonio-New Braunfels, TX" 41740 "San Diego-Carlsbad, CA" 41860 "San Francisco-Oakland-Hayward, CA" 41940 "San Jose-Sunnyvale-Santa Clara, CA" 42020 "San Luis Obispo-Paso Robles-Arroyo Grande, CA" 42100 "Santa Cruz-Watsonville, CA" 42140 "Santa Fe, NM" 42200 "Santa Maria-Santa Barbara, CA" 42220 "Santa Rosa, CA" 42340 "Savannah, GA" 42540 "Scranton-Wilkes-Barre-Hazleton, PA" 42660 "Seattle-Tacoma-Bellevue, WA" 42680 "Sebastian-Vero Beach, FL" 43300 "Sherman-Denison, TX" 43340 "Shreveport-Bossier City, LA~" 43420 "Sierra Vista-Douglas, AZ" 43620 "Sioux Falls, SD" 43780 "South Bend-Mishawaka, IN-MI" 43900 "Spartanburg, SC~" 44060 "Spokane-Spokane Valley, WA~" 44100 "Springfield, IL" 44140 "Springfield, MA~" 44180 "Springfield, MO" 44220 "Springfield, OH" 44700 "Stockton-Lodi, CA" 45060 "Syracuse, NY" 45220 "Tallahassee, FL" 45300 "Tampa-St. Petersburg-Clearwater, FL" 45460 "Terre Haute, IN" 45780 "Toledo, OH~" 45820 "Topeka, KS" 45940 "Trenton, NJ" 46060 "Tucson, AZ" 46140 "Tulsa, OK" 46220 "Tuscaloosa, AL~" 46340 "Tyler, TX" 46520 "Urban Honolulu, HI" 46540 "Utica-Rome, NY" 46660 "Valdosta, GA" 46700 "Vallejo-Fairfield, CA" 47020 "Victoria, TX~" 47220 "Vineland-Bridgeton, NJ" 47260 "Virginia Beach-Norfolk-Newport News, VA-NC~" 47300 "Visalia-Porterville, CA" 47380 "Waco, TX~" 47580 "Warner Robins, GA~" 47900 "Washington-Arlington-Alexandria, DC-VA-MD-WV~" 47940 "Waterloo-Cedar Falls, IA" 48060 "Watertown-Fort Drum, NY" 48140 "Wausau, WI" 48620 "Wichita, KS~" 48660 "Wichita Falls, TX" 48700 "Williamsport, PA" 49020 "Winchester, VA-WV" 49180 "Winston-Salem, NC~" 49340 "Worcester, MA-CT~" 49420 "Yakima, WA" 49620 "York-Hanover, PA" 49660 "Youngstown-Warren-Boardman, OH-PA" 49740 "Yuma, AZ"
label values  msa5yr13 "msa5yr13nl"
label variable msa5yr03 "MSA 5-year (uses June 2003 MSA delineations)"
label define  msa5yr03nl  0 "Not in MSA or MSA code not reported" 10180 "Abilene, TX" 10420 "Akron, OH" 10500 "Albany, GA" 10580 "Albany-Schenectady-Troy, NY" 10740 "Albuquerque, NM" 10900 "Allentown-Bethlehem-Easton, PA-NJ" 11020 "Altoona, PA" 11100 "Amarillo, TX" 11300 "Anderson, IN" 11340 "Anderson, SC" 11460 "Ann Arbor, MI" 11500 "Anniston-Oxford, AL" 11540 "Appleton, WI" 11700 "Asheville, NC" 12020 "Athens-Clarke County, GA" 12060 "Atlanta-Sandy Springs-Marietta, GA" 12100 "Atlantic City, NJ" 12220 "Auburn-Opelika, AL" 12260 "Augusta-Richmond County, GA-SC" 12420 "Austin-Round Rock, TX" 12540 "Bakersfield, CA" 12580 "Baltimore-Towson, MD" 12940 "Baton Rouge, LA" 12980 "Battle Creek, MI" 13140 "Beaumont-Port Arthur, TX" 13380 "Bellingham, WA" 13460 "Bend, OR" 13740 "Billings, MT" 13780 "Binghamton, NY" 13820 "Birmingham-Hoover, AL" 13980 "Blacksburg-Christiansburg-Radford, VA" 14020 "Bloomington, IN" 14060 "Bloomington-Normal, IL" 14260 "Boise City-Nampa, ID" 14500 "Boulder, CO" 14540 "Bowling Green, KY" 14740 "Bremerton-Silverdale, WA" 15180 "Brownsville-Harlingen, TX" 15380 "Buffalo-Niagara Falls, NY" 15500 "Burlington, NC" 15940 "Canton-Massillon, OH" 15980 "Cape Coral-Fort Myers, FL" 16300 "Cedar Rapids, IA" 16580 "Champaign-Urbana, IL" 16620 "Charleston, WV" 16700 "Charleston-North Charleston, SC" 16740 "Charlotte-Gastonia-Concord, NC-SC" 16820 "Charlottesville, VA" 16860 "Chattanooga, TN-GA" 16980 "Chicago-Naperville-Joliet, IL-IN-WI" 17020 "Chico, CA" 17140 "Cincinnati-Middletown, OH-KY-IN" 17420 "Cleveland, TN" 17460 "Cleveland-Elyria-Mentor, OH" 17660 "Coeur dAlene, ID" 17780 "College Station-Bryan, TX" 17820 "Colorado Springs, CO" 17860 "Columbia, MO" 17900 "Columbia, SC" 17980 "Columbus, GA-AL" 18140 "Columbus, OH" 18580 "Corpus Christi, TX" 19100 "Dallas-Fort Worth-Arlington, TX" 19340 "Davenport-Moline-Rock Island, IA-IL" 19380 "Dayton, OH" 19460 "Decatur, AL" 19500 "Decatur, IL" 19660 "Deltona-Daytona Beach-Ormond Beach, FL" 19740 "Denver-Aurora, CO" 19780 "Des Moines, IA" 19820 "Detroit-Warren-Livonia, MI" 20100 "Dover, DE" 20260 "Duluth, MN-WI" 20500 "Durham, NC" 20740 "Eau Claire, WI" 20940 "El Centro, CA" 21140 "Elkhart-Goshen, IN" 21340 "El Paso, TX" 21500 "Erie, PA" 21660 "Eugene-Springfield, OR" 21780 "Evansville, IN-KY" 22020 "Fargo, ND-MN" 22140 "Farmington, NM" 22180 "Fayetteville, NC" 22220 "Fayetteville-Springdale-Rogers, AR-MO" 22420 "Flint, MI" 22460 "Florence, AL" 22500 "Florence, SC" 22660 "Fort Collins-Loveland, CO" 22900 "Fort Smith, AR-OK" 23020 "Fort Walton Beach-Crestview-Destin, FL" 23060 "Fort Wayne, IN" 23420 "Fresno, CA" 23540 "Gainesville, FL" 23580 "Gainesville, GA" 24020 "Glens Falls, NY" 24140 "Goldsboro, NC" 24340 "Grand Rapids-Wyoming, MI" 24540 "Greeley, CO" 24580 "Green Bay, WI" 24660 "Greensboro-High Point, NC" 24860 "Greenville, SC" 25060 "Gulfport-Biloxi, MS" 25180 "Hagerstown-Martinsburg, MD-WV" 25260 "Hanford-Corcoran, CA" 25420 "Harrisburg-Carlisle, PA" 25500 "Harrisonburg, VA" 25860 "Hickory-Morganton-Lenoir, NC" 26100 "Holland-Grand Haven, MI" 26180 "Honolulu, HI" 26420 "Houston-Baytown-Sugar Land, TX" 26580 "Huntington-Ashland, WV-KY-OH" 26620 "Huntsville, AL" 26900 "Indianapolis, IN" 26980 "Iowa City, IA" 27100 "Jackson, MI" 27140 "Jackson, MS" 27260 "Jacksonville, FL" 27340 "Jacksonville, NC" 27500 "Janesville, WI" 27740 "Johnson City, TN" 27780 "Johnstown, PA" 27900 "Joplin, MO" 28020 "Kalamazoo-Portage, MI" 28100 "Kankakee-Bradley, IL" 28140 "Kansas City, MO-KS" 28420 "Kennewick-Richland-Pasco, WA" 28660 "Killeen-Temple-Fort Hood, TX" 28700 "Kingsport-Bristol, TN-VA" 28740 "Kingston, NY" 28940 "Knoxville, TN" 29100 "La Crosse, WI-MN" 29180 "Lafayette, LA" 29340 "Lake Charles, LA" 29460 "Lakeland-Winter Haven, FL" 29540 "Lancaster, PA" 29620 "Lansing-East Lansing, MI" 29700 "Laredo, TX" 29740 "Las Cruces, NM" 29820 "Las Vegas-Paradise, NV" 29940 "Lawrence, KS" 30020 "Lawton, OK" 30460 "Lexington-Fayette, KY" 30780 "Little Rock-North Little Rock, AR" 30980 "Longview, TX" 31100 "Los Angeles-Long Beach-Santa Ana, CA" 31140 "Louisville, KY-IN" 31180 "Lubbock, TX" 31340 "Lynchburg, VA" 31420 "Macon, GA" 31460 "Madera, CA" 31540 "Madison, WI" 32580 "McAllen-Edinburg-Pharr, TX" 32780 "Medford, OR" 32820 "Memphis, TN-MS-AR" 32900 "Merced, CA" 33100 "Miami-Fort Lauderdale-Miami Beach, FL" 33140 "Michigan City-La Porte, IN" 33260 "Midland, TX" 33340 "Milwaukee-Waukesha-West Allis, WI" 33460 "Minneapolis-St. Paul-Bloomington, MN-WI" 33660 "Mobile, AL" 33700 "Modesto, CA" 33740 "Monroe, LA" 33780 "Monroe, MI" 33860 "Montgomery, AL" 34060 "Morgantown, WV" 34580 "Mount Vernon-Anacortes, WA" 34740 "Muskegon-Norton Shores, MI" 34820 "Myrtle Beach-Conway-North Myrtle Beach, SC" 34900 "Napa, CA" 34940 "Naples-Marco Island, FL" 34980 "Nashville-Davidson-Murfreesboro, TN" 35380 "New Orleans-Metairie-Kenner, LA" 35620 "New York-Northern New Jersey-Long Island, NY-NJ-PA" 35660 "Niles-Benton Harbor, MI" 36100 "Ocala, FL" 36140 "Ocean City, NJ" 36220 "Odessa, TX" 36260 "Ogden-Clearfield, UT" 36420 "Oklahoma City, OK" 36500 "Olympia, WA" 36540 "Omaha-Council Bluffs, NE-IA" 36740 "Orlando, FL" 36780 "Oshkosh-Neenah, WI" 37100 "Oxnard-Thousand Oaks-Ventura, CA" 37340 "Palm Bay-Melbourne-Titusville, FL" 37460 "Panama City-Lynn Haven, FL" 37860 "Pensacola-Ferry Pass-Brent, FL" 37900 "Peoria, IL" 37980 "Philadelphia-Camden-Wilmington, PA-NJ-DE-MD" 38060 "Phoenix-Mesa-Scottsdale, AZ" 38220 "Pine Bluff, AR" 38300 "Pittsburgh, PA" 38900 "Portland-Vancouver-Beaverton, OR-WA" 38940 "Port St. Lucie-Fort Pierce, FL" 39100 "Poughkeepsie-Newburgh-Middletown, NY" 39140 "Prescott, AZ" 39340 "Provo-Orem, UT" 39380 "Pueblo, CO" 39460 "Punta Gorda, FL" 39540 "Racine, WI" 39580 "Raleigh-Cary, NC" 39740 "Reading, PA" 39820 "Redding, CA" 39900 "Reno-Sparks, NV" 40060 "Richmond, VA" 40140 "Riverside-San Bernardino-Ontario, CA" 40220 "Roanoke, VA" 40380 "Rochester, NY" 40420 "Rockford, IL" 40900 "Sacramento-Arden-Arcade-Roseville, CA" 40980 "Saginaw-Saginaw Township North, MI" 41060 "St. Cloud, MN" 41180 "St. Louis, MO-IL" 41420 "Salem, OR" 41500 "Salinas, CA" 41540 "Salisbury, MD" 41620 "Salt Lake City, UT" 41700 "San Antonio, TX" 41740 "San Diego-Carlsbad-San Marcos, CA" 41860 "San Francisco-Oakland-Fremont, CA" 41940 "San Jose-Sunnyvale-Santa Clara, CA" 42020 "San Luis Obispo-Paso Robles, CA" 42060 "Santa Barbara-Santa Maria-Goleta, CA" 42100 "Santa Cruz-Watsonville, CA" 42140 "Santa Fe, NM" 42220 "Santa Rosa-Petaluma, CA" 42260 "Sarasota-Bradenton-Venice, FL" 42340 "Savannah, GA" 42540 "Scranton-Wilkes-Barre, PA" 42660 "Seattle-Tacoma-Bellevue, WA" 43300 "Sherman-Denison, TX" 43340 "Shreveport-Bossier City, LA" 43620 "Sioux Falls, SD" 43780 "South Bend-Mishawaka, IN-MI" 43900 "Spartanburg, SC" 44060 "Spokane, WA" 44100 "Springfield, IL" 44180 "Springfield, MO" 44220 "Springfield, OH" 44700 "Stockton, CA" 45060 "Syracuse, NY" 45220 "Tallahassee, FL" 45300 "Tampa-St. Petersburg-Clearwater, FL" 45460 "Terre Haute, IN" 45780 "Toledo, OH" 45820 "Topeka, KS" 45940 "Trenton-Ewing, NJ" 46060 "Tucson, AZ" 46140 "Tulsa, OK" 46220 "Tuscaloosa, AL" 46340 "Tyler, TX" 46540 "Utica-Rome, NY" 46660 "Valdosta, GA" 46700 "Vallejo-Fairfield, CA" 46940 "Vero Beach, FL" 47020 "Victoria, TX" 47220 "Vineland-Millville-Bridgeton, NJ" 47260 "Virginia Beach-Norfolk-Newport News, VA-NC" 47300 "Visalia-Porterville, CA" 47380 "Waco, TX" 47580 "Warner Robins, GA" 47900 "Washington-Arlington-Alexandria, DC-VA-MD-WV" 47940 "Waterloo-Cedar Falls, IA" 48140 "Wausau, WI" 48620 "Wichita, KS" 48660 "Wichita Falls, TX" 48700 "Williamsport, PA" 49180 "Winston-Salem, NC" 49420 "Yakima, WA" 49620 "York-Hanover, PA" 49660 "Youngstown-Warren-Boardman, OH-PA" 49740 "Yuma, AZ" 70750 "Bangor, ME" 70900 "Barnstable Town, MA" 71650 "Boston-Cambridge-Quincy, MA-NH" 71950 "Bridgeport-Stamford-Norwalk, CT" 72400 "Burlington-South Burlington, VT" 72850 "Danbury, CT" 73450 "Hartford-West Hartford-East Hartford, CT" 74500 "Leominster-Fitchburg-Gardner, MA" 75700 "New Haven, CT" 76450 "Norwich-New London, CT-RI" 76750 "Portland-South Portland, ME" 77200 "Providence-Fall River-Warwick, RI-MA" 77350 "Rochester-Dover, NH-ME" 78100 "Springfield, MA-CT" 78700 "Waterbury, CT" 79600 "Worcester, MA-CT"
label values  msa5yr03 "msa5yr03nl"
label variable msa13chg "MSA boundary change between 2013 and 2015 surveys"
label define  msa13chgnl  1 "Yes" 2 "No" -1 "NIU (not in MSA or MSA code not reported)"
label values  msa13chg "msa13chgnl"
label variable gtcbsast "Metropolitan status"
label define  gtcbsastnl  1 "Metropolitan area - principal city" 2 "Metropolitan area - balance" 3 "Not in metropolitan area" 4 "Not identified"
label values  gtcbsast "gtcbsastnl"
label variable hanyafsv3 "Timing of nonbank transaction and credit product use"
label define  hanyafsv3nl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used"
label values  hanyafsv3 "hanyafsv3nl"
label variable hbankstat "Unbanked and underbanked"
label define  hbankstatnl  1 "Unbanked" 2 "Banked: Underbanked" 3 "Banked: Fully banked" 4 "Banked: Underbanked status unknown"
label values  hbankstat "hbankstatnl"
label variable hbankstatv2 "Unbanked and underbanked"
label define  hbankstatv2nl  1 "Unbanked" 2 "Banked: Underbanked" 3 "Banked: Fully banked" 4 "Banked: Underbanked status unknown"
label values  hbankstatv2 "hbankstatv2nl"
label variable hbankstatv3 "Unbanked and underbanked"
label define  hbankstatv3nl  1 "Unbanked" 2 "Banked: Underbanked" 3 "Banked: Fully banked"
label values  hbankstatv3 "hbankstatv3nl"
label variable hbaseresp "Base respondent - household"
label define  hbaserespnl  0 "Nonrespondent" 1 "Respondent"
label values  hbaseresp "hbaserespnl"
label variable hbnkaccm "Most common way to access account"
label define  hbnkaccmnl  1 "Bank teller" 2 "ATM/Kiosk" 3 "Telephone banking" 4 "Online banking" 5 "Mobile banking" 6 "Other" -1 "NIU"
label values  hbnkaccm "hbnkaccmnl"
label variable hbnkaccm1 "Bank account access: Bank teller"
label define  hbnkaccm1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm1 "hbnkaccm1nl"
label variable hbnkaccm2 "Bank account access: ATM/Kiosk"
label define  hbnkaccm2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm2 "hbnkaccm2nl"
label variable hbnkaccm3 "Bank account access: Telephone banking"
label define  hbnkaccm3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm3 "hbnkaccm3nl"
label variable hbnkaccm4 "Bank account access: Online banking"
label define  hbnkaccm4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm4 "hbnkaccm4nl"
label variable hbnkaccm5 "Bank account access: Mobile banking"
label define  hbnkaccm5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm5 "hbnkaccm5nl"
label variable hbnkaccm6 "Bank account access: Other"
label define  hbnkaccm6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm6 "hbnkaccm6nl"
label variable hbnkaccm7 "Bank account access: Did not access in past 12 months"
label define  hbnkaccm7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm7 "hbnkaccm7nl"
label variable hbnkaccmnbr "Number of banking access methods"
label define  hbnkaccmnbrnl  0 "Did not access account in past 12 months" 1 "1 method" 2 "2 or more methods" -1 "NIU"
label values  hbnkaccmnbr "hbnkaccmnbrnl"
label variable hbnkfutr "Likelihood of opening account"
label define  hbnkfutrnl  1 "Very likely" 2 "Somewhat likely" 3 "Not very likely" 4 "Not at all likely" -1 "NIU" 99 "Unknown"
label values  hbnkfutr "hbnkfutrnl"
label variable hbnkfutrrsn "Reason plan to open account"
label define  hbnkfutrrsnnl  1 "To put money in a safe place" 2 "To be able to write checks and pay bills" 3 "To be able to apply for a loan or mortgage" 4 "To save money for the future" 5 "To take advantage of direct deposit of paychecks" 6 "To send money to family and friends" 7 "Other" 99 "Unknown" -1 "NIU"
label values  hbnkfutrrsn "hbnkfutrrsnnl"
label variable hbnkmob1 "Mobile activity: Downloaded or used bank mobile app (conditional on using mobile banking)"
label define  hbnkmob1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob1 "hbnkmob1nl"
label variable hbnkmob2 "Mobile activity: Checked bank account balance or recent transactions (conditional on using mobile banking)"
label define  hbnkmob2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob2 "hbnkmob2nl"
label variable hbnkmob3 "Mobile activity: Made bill payment (conditional on using mobile banking)"
label define  hbnkmob3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob3 "hbnkmob3nl"
label variable hbnkmob4 "Mobile activity: Read text message alert from bank (conditional on using mobile banking)"
label define  hbnkmob4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob4 "hbnkmob4nl"
label variable hbnkmob5 "Mobile activity: Sent money to other people (conditional on using mobile banking)"
label define  hbnkmob5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob5 "hbnkmob5nl"
label variable hbnkmob6 "Mobile activity: Transferred money between accounts owned by same person (conditional on using mobile banking)"
label define  hbnkmob6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob6 "hbnkmob6nl"
label variable hbnkmob7 "Mobile activity: Deposited check electronically (conditional on using mobile banking)"
label define  hbnkmob7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob7 "hbnkmob7nl"
label variable hbnkmob8 "Mobile activity: Located closest in-network ATM or bank branch (conditional on using mobile banking)"
label define  hbnkmob8nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob8 "hbnkmob8nl"
label variable hbnkmob9 "Mobile activity: Other (conditional on using mobile banking)"
label define  hbnkmob9nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmob9 "hbnkmob9nl"
label variable hbnknew "Length of bank account ownership"
label define  hbnknewnl  1 "Became banked in past 12 months" 2 "Banked prior to past 12 months" -1 "NIU"
label values  hbnknew "hbnknewnl"
label variable hbnknewrsn "Reason opened account in past 12 months"
label define  hbnknewrsnnl  1 "To put money in a safe place" 2 "To pay for everyday purchases, write checks, or/and pay bills" 3 "To be able to apply for a loan or mortgage" 4 "To save money for the future" 5 "To receive direct deposit" 6 "To send money to family or friends" 7 "Other" -1 "NIU"
label values  hbnknewrsn "hbnknewrsnnl"
label variable hbnkpp "Prepaid card obtained in bank branch, used in past 30 days"
label define  hbnkppnl  1 "Yes" 2 "No"
label values  hbnkpp "hbnkppnl"
label variable hbnkppunb "Prepaid card obtained in bank branch, used in past 30 days, unbanked"
label define  hbnkppunbnl  1 "Yes" 2 "No"
label values  hbnkppunb "hbnkppunbnl"
label variable hbnkprev "Previously banked"
label define  hbnkprevnl  1 "Once had bank account" 2 "Never had bank account" -1 "NIU" 99 "Unknown"
label values  hbnkprev "hbnkprevnl"
label variable hbnkprevly "Previously banked (within last year)"
label define  hbnkprevlynl  1 "Had bank account within last year" 2 "Had bank account more than 1 year ago" 3 "Never had bank account" -1 "NIU" 98 "Previously banked, recency unknown" 99 "Unknown"
label values  hbnkprevly "hbnkprevlynl"
label variable hbnktyp "Bank account type"
label define  hbnktypnl  1 "Unbanked" 2 "Checking and savings" 3 "Savings only" 4 "Checking only" 99 "Banked, account type unknown"
label values  hbnktyp "hbnktypnl"
label variable hbnktypc "Bank account type, banked households"
label define  hbnktypcnl  2 "Checking and savings" 3 "Savings only" 4 "Checking only" -1 "NIU"
label values  hbnktypc "hbnktypcnl"
label variable hddacct "Direct deposit account type"
label define  hddacctnl  1 "Checking and savings" 2 "Checking only" 3 "Savings only" 4 "Direct deposit account type unknown" 5 "No direct deposit (banked)" -1 "NIU"
label values  hddacct "hddacctnl"
label variable hdirdep "Direct deposit status"
label define  hdirdepnl  1 "Has direct deposit" 2 "No direct deposit" -1 "NIU"
label values  hdirdep "hdirdepnl"
label variable hevent1 "HH event: Significant loss of income"
label define  hevent1nl  1 "Yes" 2 "No"
label values  hevent1 "hevent1nl"
label variable hevent1bc "Event contributed to bank account closing: Significant loss of income"
label define  hevent1bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent1bc "hevent1bcnl"
label variable hevent1bo "Event contributed to bank account opening: Significant loss of income"
label define  hevent1bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent1bo "hevent1bonl"
label variable hevent2 "HH event: Significant increase in income"
label define  hevent2nl  1 "Yes" 2 "No"
label values  hevent2 "hevent2nl"
label variable hevent2bc "Event contributed to bank account closing: Significant increase in income"
label define  hevent2bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent2bc "hevent2bcnl"
label variable hevent2bo "Event contributed to bank account opening: Significant increase in income"
label define  hevent2bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent2bo "hevent2bonl"
label variable hevent3 "HH event: Job loss"
label define  hevent3nl  1 "Yes" 2 "No"
label values  hevent3 "hevent3nl"
label variable hevent3bc "Event contributed to bank account closing: Job loss"
label define  hevent3bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent3bc "hevent3bcnl"
label variable hevent3bo "Event contributed to bank account opening: Job loss"
label define  hevent3bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent3bo "hevent3bonl"
label variable hevent4 "HH event: New job"
label define  hevent4nl  1 "Yes" 2 "No"
label values  hevent4 "hevent4nl"
label variable hevent4bc "Event contributed to bank account closing: New job"
label define  hevent4bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent4bc "hevent4bcnl"
label variable hevent4bo "Event contributed to bank account opening: New job"
label define  hevent4bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent4bo "hevent4bonl"
label variable hevent5 "HH event: Retirement"
label define  hevent5nl  1 "Yes" 2 "No"
label values  hevent5 "hevent5nl"
label variable hevent5bc "Event contributed to bank account closing: Retirement"
label define  hevent5bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent5bc "hevent5bcnl"
label variable hevent5bo "Event contributed to bank account opening: Retirement"
label define  hevent5bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent5bo "hevent5bonl"
label variable hevent6 "HH event: Significant increase in household expenses"
label define  hevent6nl  1 "Yes" 2 "No"
label values  hevent6 "hevent6nl"
label variable hevent6bc "Event contributed to bank account closing: Significant increase in household expenses"
label define  hevent6bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent6bc "hevent6bcnl"
label variable hevent6bo "Event contributed to bank account opening: Significant increase in household expenses"
label define  hevent6bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent6bo "hevent6bonl"
label variable hevent7 "HH event: Significant decrease in household expenses"
label define  hevent7nl  1 "Yes" 2 "No"
label values  hevent7 "hevent7nl"
label variable hevent7bc "Event contributed to bank account closing: Significant decrease in household expenses"
label define  hevent7bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent7bc "hevent7bcnl"
label variable hevent7bo "Event contributed to bank account opening: Significant decrease in household expenses"
label define  hevent7bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent7bo "hevent7bonl"
label variable hevent8 "HH event: Divorce or death"
label define  hevent8nl  1 "Yes" 2 "No"
label values  hevent8 "hevent8nl"
label variable hevent8bc "Event contributed to bank account closing: Divorce or death"
label define  hevent8bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent8bc "hevent8bcnl"
label variable hevent8bo "Event contributed to bank account opening: Divorce or death"
label define  hevent8bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent8bo "hevent8bonl"
label variable hevent9 "HH event: New marriage, civil union, or domestic partnership"
label define  hevent9nl  1 "Yes" 2 "No"
label values  hevent9 "hevent9nl"
label variable hevent9bc "Event contributed to bank account closing: New marriage, civil union, or domestic partnership"
label define  hevent9bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent9bc "hevent9bcnl"
label variable hevent9bo "Event contributed to bank account opening: New marriage, civil union, or domestic partnership"
label define  hevent9bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent9bo "hevent9bonl"
label variable hevent10 "HH event: Birth, adoption, or other addition of a child"
label define  hevent10nl  1 "Yes" 2 "No"
label values  hevent10 "hevent10nl"
label variable hevent10bc "Event contributed to bank account closing: Birth, adoption, or other addition of a child"
label define  hevent10bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent10bc "hevent10bcnl"
label variable hevent10bo "Event contributed to bank account opening: Birth, adoption, or other addition of a child"
label define  hevent10bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent10bo "hevent10bonl"
label variable hevent11 "HH event: Move or relocation"
label define  hevent11nl  1 "Yes" 2 "No"
label values  hevent11 "hevent11nl"
label variable hevent11bc "Event contributed to bank account closing: Move or relocation"
label define  hevent11bcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent11bc "hevent11bcnl"
label variable hevent11bo "Event contributed to bank account opening: Move or relocation"
label define  hevent11bonl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent11bo "hevent11bonl"
label variable hhaschk "Checking account ownership"
label define  hhaschknl  1 "Has checking account" 2 "Does not have checking account" 99 "Unknown"
label values  hhaschk "hhaschknl"
label variable hhassav "Savings account ownership"
label define  hhassavnl  1 "Has savings account" 2 "Does not have savings account" 99 "Unknown"
label values  hhassav "hhassavnl"
label variable hhfamtyp "Household family type"
label define  hhfamtypnl  1 "Family household" 2 "Nonfamily household" 3 "Other"
label values  hhfamtyp "hhfamtypnl"
label variable hhincome "Family income"
label define  hhincomenl  1 "Less than $15,000" 2 "$15,000 to $30,000" 3 "$30,000 to $50,000" 4 "$50,000 to $75,000" 5 "At least $75,000"
label values  hhincome "hhincomenl"
label variable hhincome2 "Family income (excludes imputed values)"
label define  hhincome2nl  1 "Less than $15,000" 2 "$15,000 to $30,000" 3 "$30,000 to $50,000" 4 "$50,000 to $75,000" 5 "At least $75,000" 99 "Missing"
label values  hhincome2 "hhincome2nl"
label variable hhtenure "Homeownership"
label define  hhtenurenl  1 "Homeowner" 2 "Non-homeowner"
label values  hhtenure "hhtenurenl"
label variable hhtype "Household type"
label define  hhtypenl  1 "Married couple" 2 "Unmarried female-householder family" 3 "Unmarried male-householder family" 4 "Female-householder nonfamily" 5 "Male-householder nonfamily" 6 "Other"
label values  hhtype "hhtypenl"
label variable hhtypev2 "Household type (more detail)"
label define  hhtypev2nl  1 "Married couple" 2 "Unmarried female-householder family: Single-mother household" 3 "Unmarried female-householder family: Other" 4 "Unmarried male-householder family: Single-father household" 5 "Unmarried male-householder family: Other" 6 "Female-householder nonfamily" 7 "Male-householder nonfamily" 8 "Other"
label values  hhtypev2 "hhtypev2nl"
label variable hintacc "Internet access through home or work"
label define  hintaccnl  1 "Has access" 2 "Does not have access"
label values  hintacc "hintaccnl"
label variable hmobnk "Banking status of households that used mobile banking"
label define  hmobnknl  1 "Underbanked and used mobile banking" 2 "Fully banked and used mobile banking" -1 "NIU"
label values  hmobnk "hmobnknl"
label variable hmphone "Mobile phone"
label define  hmphonenl  1 "Has mobile phone" 2 "Does not have mobile phone"
label values  hmphone "hmphonenl"
label variable hmphoneppu1 "Used prepaid card through mobile phone: Downloaded or used prepaid card providers mobile app"
label define  hmphoneppu1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu1 "hmphoneppu1nl"
label variable hmphoneppu2 "Used prepaid card through mobile phone: Checked prepaid account balance or recent transactions"
label define  hmphoneppu2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu2 "hmphoneppu2nl"
label variable hmphoneppu3 "Used prepaid card through mobile phone: Made bill payment using prepaid card"
label define  hmphoneppu3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu3 "hmphoneppu3nl"
label variable hmphoneppu4 "Used prepaid card through mobile phone: Received text message alert from prepaid card account"
label define  hmphoneppu4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu4 "hmphoneppu4nl"
label variable hmphoneppu5 "Used prepaid card through mobile phone: Sent money to other people from prepaid card account"
label define  hmphoneppu5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu5 "hmphoneppu5nl"
label variable hmphoneppu6 "Used prepaid card through mobile phone: Transferred money between accounts owned by same person"
label define  hmphoneppu6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu6 "hmphoneppu6nl"
label variable hmphoneppu7 "Used prepaid card through mobile phone: Deposited check electronically to prepaid card account"
label define  hmphoneppu7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu7 "hmphoneppu7nl"
label variable hmphoneppu8 "Used prepaid card through mobile phone: Waved or tapped mobile phone at cash register to pay for purchase with prepaid card"
label define  hmphoneppu8nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu8 "hmphoneppu8nl"
label variable hmphoneppu9 "Used prepaid card through mobile phone: Other"
label define  hmphoneppu9nl  1 "Yes" 2 "No" -1 "NIU"
label values  hmphoneppu9 "hmphoneppu9nl"
label variable hplacecc "Nonbank check casher: Typical location used"
label define  hplaceccnl  1 "Large retail or department store" 2 "Grocery, liquor, convenience, or drug store" 3 "Stand alone nonbank financial services store" -1 "NIU" 99 "Unknown location"
label values  hplacecc "hplaceccnl"
label variable hplacemo "Nonbank money order: Typical location used"
label define  hplacemonl  1 "Post office" 2 "Large retail or department store" 3 "Grocery, liquor, convenience, or drug store" 4 "Stand alone nonbank financial services store" -1 "NIU" 99 "Other/Unknown"
label values  hplacemo "hplacemonl"
label variable hplacepp "Prepaid card: Typical location to get it"
label define  hplaceppnl  1 "Large retail or department store" 2 "Grocery, liquor, convenience, or drug store" 3 "Stand alone nonbank financial services store" 4 "A bank branch" 5 "Internet/Online" 6 "Over the telephone" 7 "Provided by someone else" -1 "NIU" 99 "Unknown"
label values  hplacepp "hplaceppnl"
label variable hplacerm "Nonbank international remittance: Typical location used"
label define  hplacermnl  1 "Large retail or department store" 2 "Grocery, liquor, convenience, or drug store" 3 "Stand alone nonbank financial services store" 4 "Mobile phone" 5 "Online through computer" -1 "NIU" 99 "Other/Unknown"
label values  hplacerm "hplacermnl"
label variable hrloadpp "Prepaid card, reloaded in past 12 months"
label define  hrloadppnl  1 "Card was reloaded" 2 "Card was not reloaded" -1 "NIU"
label values  hrloadpp "hrloadppnl"
label variable hrloadppm1 "Prepaid card access or load: Bank teller"
label define  hrloadppm1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm1 "hrloadppm1nl"
label variable hrloadppm2 "Prepaid card access or load: ATM/Kiosk"
label define  hrloadppm2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm2 "hrloadppm2nl"
label variable hrloadppm3 "Prepaid card access or load: Retail store clerk"
label define  hrloadppm3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm3 "hrloadppm3nl"
label variable hrloadppm4 "Prepaid card access or load: Telephone"
label define  hrloadppm4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm4 "hrloadppm4nl"
label variable hrloadppm5 "Prepaid card access or load: Mobile phone through text messaging, phone Internet browser, mobile app, email"
label define  hrloadppm5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm5 "hrloadppm5nl"
label variable hrloadppm6 "Prepaid card access or load: Online through desktop, laptop, or tablet"
label define  hrloadppm6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm6 "hrloadppm6nl"
label variable hrloadppm7 "Prepaid card access or load: Direct deposit of paycheck"
label define  hrloadppm7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm7 "hrloadppm7nl"
label variable hrloadppm8 "Prepaid card access or load: Other"
label define  hrloadppm8nl  1 "Yes" 2 "No" -1 "NIU"
label values  hrloadppm8 "hrloadppm8nl"
label variable hsmphone "Smartphone"
label define  hsmphonenl  1 "Smartphone" 2 "Non-smartphone" 3 "No mobile phone"
label values  hsmphone "hsmphonenl"
label variable hsupresp "Supplement respondent - household"
label define  hsuprespnl  0 "Nonrespondent" 1 "Respondent"
label values  hsupresp "hsuprespnl"
label variable hunbnk "Unbanked"
label define  hunbnknl  1 "Unbanked" 2 "Has bank account"
label values  hunbnk "hunbnknl"
label variable hunbnkpp "Unbanked, used prepaid card in past 30 days"
label define  hunbnkppnl  1 "Yes" 2 "No"
label values  hunbnkpp "hunbnkppnl"
label variable hunbnkr1 "Why unbanked: Inconvenient hours or locations"
label define  hunbnkr1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr1 "hunbnkr1nl"
label variable hunbnkr2 "Why unbanked: Account fees too high or unpredictable"
label define  hunbnkr2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr2 "hunbnkr2nl"
label variable hunbnkr3 "Why unbanked: Banks do not offer needed products or services"
label define  hunbnkr3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr3 "hunbnkr3nl"
label variable hunbnkr4 "Why unbanked: Do not like dealing with or do not trust banks"
label define  hunbnkr4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr4 "hunbnkr4nl"
label variable hunbnkr5 "Why unbanked: Do not have enough money to keep in account or meet minimum balance"
label define  hunbnkr5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr5 "hunbnkr5nl"
label variable hunbnkr6 "Why unbanked: Not using bank provides more privacy"
label define  hunbnkr6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr6 "hunbnkr6nl"
label variable hunbnkr7 "Why unbanked: ID, credit, or banking history problems"
label define  hunbnkr7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr7 "hunbnkr7nl"
label variable hunbnkr8 "Why unbanked: Other reason"
label define  hunbnkr8nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr8 "hunbnkr8nl"
label variable hunbnkrm "Main reason unbanked"
label define  hunbnkrmnl  1 "Previously had an account but the bank closed it" 2 "ID, credit, or banking history problems" 3 "Banks do not have convenient hours or locations" 4 "Bank account fees or minimum balance requirements are too high" 5 "Banks do not offer the needed products or services" 6 "Do not like dealing with and/or do not trust banks" 7 "Do not have enough money" 8 "Do not know how to open or manage an account" 9 "Do not need or want an account" 10 "Other/None of the above" 99 "Unknown" -1 "NIU"
label values  hunbnkrm "hunbnkrmnl"
label variable hunbnkrmv2 "Main reason unbanked"
label define  hunbnkrmv2nl  1 "Inconvenient hours or locations" 2 "Account fees too high or unpredictable" 3 "Banks do not offer needed products or services" 4 "Do not like dealing with or do not trust banks" 5 "Do not have enough money to keep in account or meet minimum balance" 6 "Not using bank provides more privacy" 7 "ID, credit, or banking history problems" 8 "Other reason" 99 "Unknown reason" -1 "NIU"
label values  hunbnkrmv2 "hunbnkrmv2nl"
label variable huse1afs "Nonbank transaction and credit product use, ever"
label define  huse1afsnl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse1afs "huse1afsnl"
label variable huse1afsc "Nonbank credit product use, ever"
label define  huse1afscnl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse1afsc "huse1afscnl"
label variable huse1afscv2 "Nonbank credit product use, ever"
label define  huse1afscv2nl  1 "Has used" 2 "Has not used"
label values  huse1afscv2 "huse1afscv2nl"
label variable huse1afst "Nonbank transaction product use, ever"
label define  huse1afstnl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse1afst "huse1afstnl"
label variable huse1afstv2 "Nonbank transaction product use, ever"
label define  huse1afstv2nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse1afstv2 "huse1afstv2nl"
label variable huse1afsv2 "Nonbank transaction and credit product use, ever"
label define  huse1afsv2nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse1afsv2 "huse1afsv2nl"
label variable huse1afsv3 "Nonbank transaction and credit product use, ever"
label define  huse1afsv3nl  1 "Has used" 2 "Has not used"
label values  huse1afsv3 "huse1afsv3nl"
label variable huse1atl "Auto title loan, ever used"
label define  huse1atlnl  1 "Has ever used" 2 "Has never used"
label values  huse1atl "huse1atlnl"
label variable huse1cc "Nonbank check cashing, ever used"
label define  huse1ccnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1cc "huse1ccnl"
label variable huse1mo "Nonbank money order, ever used"
label define  huse1monl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1mo "huse1monl"
label variable huse1pdl "Payday loan, ever used"
label define  huse1pdlnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1pdl "huse1pdlnl"
label variable huse1pp "Prepaid card, ever used"
label define  huse1ppnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1pp "huse1ppnl"
label variable huse1pwn "Pawn shop loan, ever used"
label define  huse1pwnnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1pwn "huse1pwnnl"
label variable huse1ral "Refund anticipation loan, ever used"
label define  huse1ralnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1ral "huse1ralnl"
label variable huse1rm "Nonbank international remittance, ever used"
label define  huse1rmnl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1rm "huse1rmnl"
label variable huse1rto "Rent-to-own service, ever used"
label define  huse1rtonl  1 "Has ever used" 2 "Has never used" 99 "Unknown"
label values  huse1rto "huse1rtonl"
label variable huse2afsc "Nonbank credit product use, past 12 months"
label define  huse2afscnl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse2afsc "huse2afscnl"
label variable huse2afscv2 "Nonbank credit product use, past 12 months"
label define  huse2afscv2nl  1 "Has used" 2 "Has not used"
label values  huse2afscv2 "huse2afscv2nl"
label variable huse2afsnbr "Number of nonbank transaction and credit products used, past 12 months"
label define  huse2afsnbrnl  0 "Did not use" 1 "Used 1" 2 "Used 2" 3 "Used 3 or more" 99 "Unknown"
label values  huse2afsnbr "huse2afsnbrnl"
label variable huse2afsnbrv2 "Number of nonbank transaction and credit products used, past 12 months"
label define  huse2afsnbrv2nl  0 "Did not use" 1 "Used 1" 2 "Used 2" 3 "Used 3 or more"
label values  huse2afsnbrv2 "huse2afsnbrv2nl"
label variable huse2afstv1 "Nonbank transaction product use, past 12 months"
label define  huse2afstv1nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse2afstv1 "huse2afstv1nl"
label variable huse2afstv2 "Nonbank transaction product use, past 12 months"
label define  huse2afstv2nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse2afstv2 "huse2afstv2nl"
label variable huse2afstypev2 "Type of nonbank transaction and credit products used, past 12 months"
label define  huse2afstypev2nl  1 "Nonbank transaction only" 2 "Nonbank transaction and credit" 3 "Nonbank credit only" 4 "Did not use"
label values  huse2afstypev2 "huse2afstypev2nl"
label variable huse3afstypev2 "Type of nonbank transaction and credit products used, past 30 days"
label define  huse3afstypev2nl  1 "Nonbank transaction only" 2 "Nonbank transaction and credit" 3 "Nonbank credit only" 4 "Did not use"
label values  huse3afstypev2 "huse3afstypev2nl"
label variable huse2afstype "Type of nonbank transaction and credit products used, past 12 months"
label define  huse2afstypenl  1 "Nonbank transaction only" 2 "Nonbank transaction and credit" 3 "Nonbank credit only" 4 "Did not use" 98 "Nonbank products used, type unknown" 99 "Use unknown"
label values  huse2afstype "huse2afstypenl"
label variable huse2afsv2 "Nonbank transaction and credit product use, past 12 months"
label define  huse2afsv2nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse2afsv2 "huse2afsv2nl"
label variable huse2afsv3 "Nonbank transaction and credit product use, past 12 months"
label define  huse2afsv3nl  1 "Has used" 2 "Has not used"
label values  huse2afsv3 "huse2afsv3nl"
label variable huse2atl "Auto title loan, past 12 months"
label define  huse2atlnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used"
label values  huse2atl "huse2atlnl"
label variable huse2cc "Nonbank check cashing, past 12 months"
label define  huse2ccnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2cc "huse2ccnl"
label variable huse2mo "Nonbank money order, past 12 months"
label define  huse2monl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2mo "huse2monl"
label variable huse2pdl "Payday loan, past 12 months"
label define  huse2pdlnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2pdl "huse2pdlnl"
label variable huse2pp "Prepaid card, past 12 months"
label define  huse2ppnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used"
label values  huse2pp "huse2ppnl"
label variable huse2pwn "Pawn shop loan, past 12 months"
label define  huse2pwnnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2pwn "huse2pwnnl"
label variable huse2ral "Refund anticipation loan, past 12 months"
label define  huse2ralnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2ral "huse2ralnl"
label variable huse2rm "Nonbank international remittance, past 12 months"
label define  huse2rmnl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2rm "huse2rmnl"
label variable huse2rto "Rent-to-own service, past 12 months"
label define  huse2rtonl  1 "Used in past 12 months" 2 "Used but not in past 12 months" 3 "Never used" 99 "Unknown"
label values  huse2rto "huse2rtonl"
label variable huse3afsc "Nonbank credit product use, past 30 days"
label define  huse3afscnl  1 "Has used" 2 "Has not used"
label values  huse3afsc "huse3afscnl"
label variable huse3afscv2 "Nonbank credit product use, past 30 days"
label define  huse3afscv2nl  1 "Has used" 2 "Has not used"
label values  huse3afscv2 "huse3afscv2nl"
label variable huse3afstv2 "Nonbank transaction product use, past 30 days"
label define  huse3afstv2nl  1 "Has used" 2 "Has not used" 99 "Unknown"
label values  huse3afstv2 "huse3afstv2nl"
label variable huse3afsv2 "Nonbank transaction and credit product use, past 30 days"
label define  huse3afsv2nl  1 "Has used" 2 "Has not used"
label values  huse3afsv2 "huse3afsv2nl"
label variable huse3afsv3 "Nonbank transaction and credit product use, past 30 days"
label define  huse3afsv3nl  1 "Has used" 2 "Has not used"
label values  huse3afsv3 "huse3afsv3nl"
label variable huse3atl "Auto title loan, past 30 days"
label define  huse3atlnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used"
label values  huse3atl "huse3atlnl"
label variable huse3cc "Nonbank check cashing, past 30 days"
label define  huse3ccnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used" 99 "Unknown"
label values  huse3cc "huse3ccnl"
label variable huse3mo "Nonbank money order, past 30 days"
label define  huse3monl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used" 99 "Unknown"
label values  huse3mo "huse3monl"
label variable huse3mopo "Nonbank money order in past 30 days, purchased at post office"
label define  huse3moponl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  huse3mopo "huse3moponl"
label variable huse3pdl "Payday loan, past 30 days"
label define  huse3pdlnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used" 99 "Unknown"
label values  huse3pdl "huse3pdlnl"
label variable huse3pp "Prepaid card, past 30 days"
label define  huse3ppnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used"
label values  huse3pp "huse3ppnl"
label variable huse3pwn "Pawn shop loan, past 30 days"
label define  huse3pwnnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used" 99 "Unknown"
label values  huse3pwn "huse3pwnnl"
label variable huse3rm "Nonbank international remittance, past 30 days"
label define  huse3rmnl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used" 99 "Unknown"
label values  huse3rm "huse3rmnl"
label variable huse3rto "Rent-to-own service, past 30 days"
label define  huse3rtonl  1 "Used in past 30 days" 2 "Used but not in past 30 days" 3 "Never used"
label values  huse3rto "huse3rtonl"
label variable huseafscrsn "Nonbank credit: Reason used"
label define  huseafscrsnnl  1 "To make up for lost income" 2 "For basic living expenses" 3 "For house repairs or to buy an appliance" 4 "For medical expenses" 5 "For car repairs" 6 "For school or childcare expenses" 7 "For special gifts or luxuries" 8 "Other" 99 "Unknown" -1 "NIU"
label values  huseafscrsn "huseafscrsnnl"
label variable huseafscrsnv2 "Nonbank credit: Reason used"
label define  huseafscrsnv2nl  1 "To make up for job loss or decrease in income" 2 "For basic living expenses" 3 "For house or car repairs or to buy an appliance" 4 "For medical, dental or death expenses" 5 "For school or childcare expenses" 6 "For special gifts or luxuries" 7 "For legal expenses" 8 "Other" 99 "Unknown" -1 "NIU"
label values  huseafscrsnv2 "huseafscrsnv2nl"
label variable huseatl "Auto title loan use"
label define  huseatlnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used"
label values  huseatl "huseatlnl"
label variable husecc "Nonbank check cashing use"
label define  huseccnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  husecc "huseccnl"
label variable huseccrsn "Nonbank check casher: Reason used"
label define  huseccrsnnl  1 "Do not have a bank account" 2 "To get money faster" 3 "The place is more convenient" 4 "A bank charges more to cash checks" 5 "The place to cash checks asks for fewer IDs" 6 "Feel more comfortable than at a bank" 7 "Other" 99 "Unknown" -1 "NIU"
label values  huseccrsn "huseccrsnnl"
label variable huseccrsnv2 "Nonbank check casher: Reason used"
label define  huseccrsnv2nl  1 "Banks do not cash checks" 2 "To get money faster" 3 "The place to cash checks has more convenient hours or location" 4 "A bank charges more to cash checks" 5 "The place to cash checks asks for fewer IDs" 6 "The place to cash checks feels more comfortable than a bank" 7 "Do not have a bank account" 8 "Do not trust banks" 9 "Other" 99 "Unknown" -1 "NIU"
label values  huseccrsnv2 "huseccrsnv2nl"
label variable husemo "Nonbank money order use"
label define  husemonl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  husemo "husemonl"
label variable husemorsn "Nonbank money order: Reason used"
label define  husemorsnnl  1 "Banks do not sell money orders" 2 "The place to purchase money orders is more convenient than a bank" 3 "Banks charge more for money orders" 4 "The place feels more comfortable than a bank" 5 "Other" 99 "Unknown" -1 "NIU"
label values  husemorsn "husemorsnnl"
label variable husemorsnv2 "Nonbank money order: Reason used"
label define  husemorsnv2nl  1 "Banks do not sell money orders" 2 "The place to purchase money orders has more convenient hours or location" 3 "A bank charges more for money orders" 4 "The place to purchase money orders feels more comfortable than a bank" 5 "Do not have a bank account" 6 "Do not trust banks" 7 "Other" 99 "Unknown" -1 "NIU"
label values  husemorsnv2 "husemorsnv2nl"
label variable husepdl "Payday loan use"
label define  husepdlnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  husepdl "husepdlnl"
label variable husepdlol "Online payday loan use"
label define  husepdlolnl  1 "Has taken out online payday loan" 2 "Has not taken out online payday loan" -1 "NIU"
label values  husepdlol "husepdlolnl"
label variable husepdlrsn "Payday loan: Reason used"
label define  husepdlrsnnl  1 "The payday loan service is more convenient" 2 "It is easier to get a payday loan than to qualify for a bank loan" 3 "A payday loan service feels more comfortable than using a bank" 4 "Do not qualify for a bank loan" 5 "Other" 99 "Unknown" -1 "NIU"
label values  husepdlrsn "husepdlrsnnl"
label variable husepdlrsnv2 "Payday loan: Reason used"
label define  husepdlrsnv2nl  1 "Banks do not make small dollar loans" 2 "The place to get payday loans has more convenient hours or location" 3 "It is easier or faster to get a payday loan than to qualify for a bank loan" 4 "The place to get payday loans feels more comfortable than a bank" 5 "Do not qualify for a bank loan" 6 "Do not trust banks" 7 "Other" 99 "Unknown" -1 "NIU"
label values  husepdlrsnv2 "husepdlrsnv2nl"
label variable husepp "Prepaid card use"
label define  huseppnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used"
label values  husepp "huseppnl"
label variable huseppr1 "Why used prepaid card: To put money in a safe place"
label define  huseppr1nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr1 "huseppr1nl"
label variable huseppr2 "Why used prepaid card: To pay for everyday purchases or pay bills"
label define  huseppr2nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr2 "huseppr2nl"
label variable huseppr3 "Why used prepaid card: To save money for the future"
label define  huseppr3nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr3 "huseppr3nl"
label variable huseppr4 "Why used prepaid card: To receive payments"
label define  huseppr4nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr4 "huseppr4nl"
label variable huseppr5 "Why used prepaid card: To send or give money"
label define  huseppr5nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr5 "huseppr5nl"
label variable huseppr6 "Why used prepaid card: To control spending"
label define  huseppr6nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr6 "huseppr6nl"
label variable huseppr7 "Why used prepaid card: Other"
label define  huseppr7nl  1 "Yes" 2 "No" -1 "NIU"
label values  huseppr7 "huseppr7nl"
label variable husepprm "Main reason used prepaid card"
label define  husepprmnl  1 "To put money in a safe place" 2 "To pay for everyday purchases or pay bills" 3 "To save money for the future" 4 "To receive payments" 5 "To send or give money" 6 "To control spending" 7 "Other" -1 "NIU"
label values  husepprm "husepprmnl"
label variable husepwn "Pawn shop loan use"
label define  husepwnnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  husepwn "husepwnnl"
label variable husepwnrsn "Pawn shop loan: Reason used"
label define  husepwnrsnnl  1 "Banks do not have small loans" 2 "The pawn shop service is more convenient" 3 "It is easier to get money from a pawn shop than to qualify for a bank loan" 4 "More comfortable at a pawn shop than at a bank" 5 "Do not qualify for a bank loan" 6 "Other" 99 "Unknown" -1 "NIU"
label values  husepwnrsn "husepwnrsnnl"
label variable husepwnrsnv2 "Pawn shop loan: Reason used"
label define  husepwnrsnv2nl  1 "Banks do not make small dollar loans" 2 "The pawn shop has more convenient hours or location" 3 "It is easier and faster to get money from a pawn shop than to qualify for a bank loan" 4 "The pawn shop feels more comfortable than a bank" 5 "Do not qualify for a bank loan" 6 "Do not trust banks" 7 "Other" 99 "Unknown" -1 "NIU"
label values  husepwnrsnv2 "husepwnrsnv2nl"
label variable huseral "Refund anticipation loan use"
label define  huseralnl  2 "Used: In past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  huseral "huseralnl"
label variable huserm "Nonbank international remittance use"
label define  husermnl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used" 99 "Use unknown"
label values  huserm "husermnl"
label variable husermrsnv2 "Nonbank international remittance: Reason used"
label define  husermrsnv2nl  1 "Banks do not send money abroad" 2 "The money gets there faster" 3 "The place to give or send money has more convenient hours or location" 4 "A bank charges more to send money abroad" 5 "The place to give or send money feels more comfortable than a bank" 6 "Do not have a bank account" 7 "Do not trust banks" 8 "Other" 99 "Unknown" -1 "NIU"
label values  husermrsnv2 "husermrsnv2nl"
label variable huserto "Rent-to-own service use"
label define  husertonl  1 "Used: In past 30 days" 2 "Used: Not in past 30 days but in past 12 months" 3 "Used: Not in past 12 months" 4 "Never used"
label values  huserto "husertonl"
label variable husespyrl "Payroll card: Receives payment for wages"
label define  husespyrlnl  1 "Receives payment on payroll card" 2 "Does not receive payment on payroll card" 99 "Unknown"
label values  husespyrl "husespyrlnl"
label variable pagegrp "Age group"
label define  pagegrpnl  1 "15 to 24 years" 2 "25 to 34 years" 3 "35 to 44 years" 4 "45 to 54 years" 5 "55 to 64 years" 6 "65 years or more"
label values  pagegrp "pagegrpnl"
label variable pdisabl_age25to64 "Disability status"
label define  pdisabl_age25to64nl  1 "Disabled, aged 25 to 64" 2 "Not disabled, aged 25 to 64" 99 "Not applicable (not aged 25 to 64)"
label values  pdisabl_age25to64 "pdisabl_age25to64nl"
label variable peducgrp "Education"
label define  peducgrpnl  1 "No high school diploma" 2 "High school diploma" 3 "Some college" 4 "College degree"
label values  peducgrp "peducgrpnl"
label variable pempstat "Employment status"
label define  pempstatnl  1 "Employed" 2 "Unemployed" 3 "Not in labor force"
label values  pempstat "pempstatnl"
label variable pnativ "Citizenship and place of birth"
label define  pnativnl  1 "U.S.-born" 2 "Foreign-born citizen" 3 "Foreign-born noncitizen"
label values  pnativ "pnativnl"
label variable pnativ2 "Citizenship and place of birth (less detail)"
label define  pnativ2nl  1 "U.S.-born" 2 "Foreign-born citizen or foreign-born noncitizen"
label values  pnativ2 "pnativ2nl"
label variable praceeth "Race/Ethnicity (previous definition)"
label define  praceethnl  1 "Black" 2 "Hispanic" 3 "Asian" 4 "American Indian or Alaska Native" 5 "Native Hawaiian or Other Pacific Islander" 6 "White" 7 "Other"
label values  praceeth "praceethnl"
label variable praceeth2 "Race/Ethnicity (previous definition, less detail)"
label define  praceeth2nl  1 "Black" 2 "Hispanic" 3 "Asian" 4 "White" 5 "Other"
label values  praceeth2 "praceeth2nl"
label variable hbnktrans "Transitions in bank account ownership"
label define  hbnktransnl  1 "Longer-term unbanked" 2 "Recently unbanked" 3 "Recently banked" 4 "Longer-term banked"
label values  hbnktrans "hbnktransnl"
label variable hbnktransv2 "Transitions in bank account ownership"
label define  hbnktransv2nl  1 "Longer-term unbanked" 2 "Recently unbanked" 3 "Recently banked" 4 "Longer-term banked"
label values  hbnktransv2 "hbnktransv2nl"
label variable hbranchstat "Bank account access: Use of bank teller and other methods"
label define  hbranchstatnl  1 "Used bank teller only" 2 "Used bank teller and other methods" 3 "Did not use bank teller but used other methods" -1 "NIU"
label values  hbranchstat "hbranchstatnl"
label variable hbranchatmstat "Bank account access: Use of physical channels and other methods"
label define  hbranchatmstatnl  1 "Used physical channels only" 2 "Used physical channels and other methods" 3 "Did not use physical channels but used other methods" -1 "NIU"
label values  hbranchatmstat "hbranchatmstatnl"
label variable hunbnkr1v3 "Why unbanked: Inconvenient hours"
label define  hunbnkr1v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr1v3 "hunbnkr1v3nl"
label variable hunbnkr2v3 "Why unbanked: Inconvenient locations"
label define  hunbnkr2v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr2v3 "hunbnkr2v3nl"
label variable hunbnkr3v3 "Why unbanked: Account fees too high"
label define  hunbnkr3v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr3v3 "hunbnkr3v3nl"
label variable hunbnkr4v3 "Why unbanked: Account fees unpredictable"
label define  hunbnkr4v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr4v3 "hunbnkr4v3nl"
label variable hunbnkr5v3 "Why unbanked: Banks do not offer needed products or services"
label define  hunbnkr5v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr5v3 "hunbnkr5v3nl"
label variable hunbnkr6v3 "Why unbanked: Do not trust banks"
label define  hunbnkr6v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr6v3 "hunbnkr6v3nl"
label variable hunbnkr7v3 "Why unbanked: Do not have enough money to keep in account"
label define  hunbnkr7v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr7v3 "hunbnkr7v3nl"
label variable hunbnkr8v3 "Why unbanked: Avoiding bank gives more privacy"
label define  hunbnkr8v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr8v3 "hunbnkr8v3nl"
label variable hunbnkr9v3 "Why unbanked: ID, credit, or former bank account problems"
label define  hunbnkr9v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr9v3 "hunbnkr9v3nl"
label variable hunbnkr10v3 "Why unbanked: Other reason"
label define  hunbnkr10v3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr10v3 "hunbnkr10v3nl"
label variable hunbnkrmv3 "Main reason unbanked"
label define  hunbnkrmv3nl  1 "Inconvenient hours" 2 "Inconvenient locations" 3 "Account fees too high" 4 "Account fees unpredictable" 5 "Banks do not offer needed products or services" 6 "Do not trust banks" 7 "Do not have enough money to keep in account" 8 "Avoiding bank gives more privacy" 9 "ID, credit, or former bank account problems" 10 "Other reason" 98 "Did not select a reason" -1 "NIU"
label values  hunbnkrmv3 "hunbnkrmv3nl"
label variable hbnkintsrv "How interested are banks in serving households like yours?"
label define  hbnkintsrvnl  1 "Very interested" 2 "Somewhat interested" 3 "Not at all interested" 98 "Unknown: Do not know"
label values  hbnkintsrv "hbnkintsrvnl"
label variable huse12pp "Used prepaid card in past 12 months"
label define  huse12ppnl  1 "Yes" 2 "No"
label values  huse12pp "huse12ppnl"
label variable hppwhere1 "Prepaid card, where from: Bank location or bank website"
label define  hppwhere1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere1 "hppwhere1nl"
label variable hppwhere2 "Prepaid card, where from: Store or website that is not a bank"
label define  hppwhere2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere2 "hppwhere2nl"
label variable hppwhere3 "Prepaid card, where from: Government agency"
label define  hppwhere3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere3 "hppwhere3nl"
label variable hppwhere4 "Prepaid card, where from: Employer payroll card"
label define  hppwhere4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere4 "hppwhere4nl"
label variable hppwhere5 "Prepaid card, where from: Family or friends"
label define  hppwhere5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere5 "hppwhere5nl"
label variable hppwhere6 "Prepaid card, where from: Other"
label define  hppwhere6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere6 "hppwhere6nl"
label variable hppwhere99 "Prepaid card, where from: Unknown"
label define  hppwhere99nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere99 "hppwhere99nl"
label variable hppgovrsn1 "Prepaid card from government: To receive social security or disability benefits"
label define  hppgovrsn1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppgovrsn1 "hppgovrsn1nl"
label variable hppgovrsn2 "Prepaid card from government: To receive unemployment benefits"
label define  hppgovrsn2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppgovrsn2 "hppgovrsn2nl"
label variable hppgovrsn3 "Prepaid card from government: To receive food or child care benefits"
label define  hppgovrsn3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppgovrsn3 "hppgovrsn3nl"
label variable hppgovrsn4 "Prepaid card from government: Other"
label define  hppgovrsn4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppgovrsn4 "hppgovrsn4nl"
label variable huse12cc "Used nonbank check cashing in past 12 months"
label define  huse12ccnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12cc "huse12ccnl"
label variable huse12mo "Used nonbank money order in past 12 months"
label define  huse12monl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12mo "huse12monl"
label variable huse12pdl "Used payday loan in past 12 months"
label define  huse12pdlnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12pdl "huse12pdlnl"
label variable huse12pwn "Used pawn shop loan in past 12 months"
label define  huse12pwnnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12pwn "huse12pwnnl"
label variable huse12ral "Used refund anticipation loan in past 12 months"
label define  huse12ralnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12ral "huse12ralnl"
label variable huse12rto "Used rent-to-own service in past 12 months"
label define  huse12rtonl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12rto "huse12rtonl"
label variable huse12atl "Used auto title loan in past 12 months"
label define  huse12atlnl  1 "Yes" 2 "No"
label values  huse12atl "huse12atlnl"
label variable huse12rmany "Used any international remittance (bank or nonbank) in past 12 months"
label define  huse12rmanynl  1 "Yes" 2 "No"
label values  huse12rmany "huse12rmanynl"
label variable huse12rmbnk "Used international remittance through bank in past 12 months"
label define  huse12rmbnknl  1 "Yes" 2 "No"
label values  huse12rmbnk "huse12rmbnknl"
label variable htyprmbnk "Used international remittance through bank in typical month"
label define  htyprmbnknl  1 "Yes" 2 "No"
label values  htyprmbnk "htyprmbnknl"
label variable huse12rm "Used international remittance through nonbank in past 12 months"
label define  huse12rmnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12rm "huse12rmnl"
label variable htyprmnbnk "Used international remittance through nonbank in typical month"
label define  htyprmnbnknl  1 "Yes" 2 "No"
label values  htyprmnbnk "htyprmnbnknl"
label variable huse12rmtype "International remittance: Types sent in past 12 months"
label define  huse12rmtypenl  1 "Used nonbank (and not bank)" 2 "Used nonbank and bank" 3 "Used bank (and not nonbank)" 4 "Sent, place unknown" 5 "Did not send"
label values  huse12rmtype "huse12rmtypenl"
label variable htyprmtype "International remittance: Types sent in typical month"
label define  htyprmtypenl  1 "Nonbank only" 2 "Nonbank and bank" 3 "Bank only" 4 "Sent in past 12 months but not in typical month" 5 "Did not send in past 12 months"
label values  htyprmtype "htyprmtypenl"
label variable htypincchkmo "Typical income: Paper check or money order"
label define  htypincchkmonl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincchkmo "htypincchkmonl"
label variable htypincddbnk "Typical income: Direct deposit or electronic transfer into bank account"
label define  htypincddbnknl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincddbnk "htypincddbnknl"
label variable htypincddpp "Typical income: Direct deposit or electronic transfer onto prepaid card"
label define  htypincddppnl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincddpp "htypincddppnl"
label variable htypinccash "Typical income: Cash"
label define  htypinccashnl  1 "Yes" 2 "No" -1 "NIU"
label values  htypinccash "htypinccashnl"
label variable htypincoth "Typical income: Other"
label define  htypincothnl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincoth "htypincothnl"
label variable htypinccc "Typical income: Used nonbank check casher"
label define  htypincccnl  1 "Yes" 2 "No" -1 "NIU"
label values  htypinccc "htypincccnl"
label variable htypincnone "Typical income: None selected"
label define  htypincnonenl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincnone "htypincnonenl"
label variable htypincbnka "Typical income: Any bank method"
label define  htypincbnkanl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincbnka "htypincbnkanl"
label variable htypincbnko "Typical income: Only bank methods"
label define  htypincbnkonl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincbnko "htypincbnkonl"
label variable htyppaycash "Typical billpay: Cash"
label define  htyppaycashnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaycash "htyppaycashnl"
label variable htyppaybnkchk "Typical billpay: Personal check"
label define  htyppaybnkchknl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkchk "htyppaybnkchknl"
label variable htyppaybnkdc "Typical billpay: Debit card"
label define  htyppaybnkdcnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkdc "htyppaybnkdcnl"
label variable htyppaycc "Typical billpay: Credit card"
label define  htyppayccnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaycc "htyppayccnl"
label variable htyppaypp "Typical billpay: Prepaid card"
label define  htyppayppnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaypp "htyppayppnl"
label variable htyppaybnkbp "Typical billpay: Electronic payment from bank account"
label define  htyppaybnkbpnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkbp "htyppaybnkbpnl"
label variable htyppaynbnkmo "Typical billpay: Nonbank money order"
label define  htyppaynbnkmonl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaynbnkmo "htyppaynbnkmonl"
label variable htyppaybnkmo "Typical billpay: Bank money order or cashiers check"
label define  htyppaybnkmonl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkmo "htyppaybnkmonl"
label variable htyppayoth "Typical billpay: Other"
label define  htyppayothnl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppayoth "htyppayothnl"
label variable htyppaym "Typical billpay: Most common method"
label define  htyppaymnl  1 "Cash" 2 "Personal check" 3 "Debit card" 4 "Credit card" 5 "Prepaid card" 6 "Electronic payment from bank account" 7 "Nonbank money order" 8 "Bank money order or cashiers check" 9 "Other" 98 "Did not select a method" -1 "NIU"
label values  htyppaym "htyppaymnl"
label variable htyppaynone "Typical billpay: None selected"
label define  htyppaynonenl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaynone "htyppaynonenl"
label variable htyppaybnka "Typical billpay: Any bank method"
label define  htyppaybnkanl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnka "htyppaybnkanl"
label variable htyppaybnko "Typical billpay: Only bank methods"
label define  htyppaybnkonl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnko "htyppaybnkonl"
label variable htypbnko "Typical billpay and income receipt: Only bank methods"
label define  htypbnkonl  1 "Yes" 2 "No" -1 "NIU"
label values  htypbnko "htypbnkonl"
label variable htypbnkoafsc "Underbanked households: use of banks to pay bills and receive income in a typical month, and use of nonbank credit in past 12 months"
label define  htypbnkoafscnl  1 "Used only banks, no nonbank credit" 2 "Used only banks, used nonbank credit" 3 "Did not use only banks, no nonbank credit" 4 "Did not use only banks, used nonbank credit" -1 "NIU"
label values  htypbnkoafsc "htypbnkoafscnl"
label variable hcred12cc "Had Visa, MasterCard, American Express, or Discover credit card in past 12 months"
label define  hcred12ccnl  1 "Yes" 2 "No"
label values  hcred12cc "hcred12ccnl"
label variable hcred12bnk "Had personal loan or line of credit from bank in past 12 months"
label define  hcred12bnknl  1 "Yes" 2 "No"
label values  hcred12bnk "hcred12bnknl"
label variable hcred12bnkv2 "Had other personal loans or lines of credit from bank in past 12 months"
label define  hcred12bnkv2nl  1 "Yes" 2 "No"
label values  hcred12bnkv2 "hcred12bnkv2nl"
label variable hcred12ccorbnk "Used bank credit product in past 12 months"
label define  hcred12ccorbnknl  1 "Yes" 2 "No"
label values  hcred12ccorbnk "hcred12ccorbnknl"
label variable hcred12newapp "Applied for credit card or personal loan or line of credit from bank in past 12 months"
label define  hcred12newappnl  1 "Yes" 2 "No"
label values  hcred12newapp "hcred12newappnl"
label variable hcred12denied "Applied for credit card or personal loan or line of credit from bank in past 12 months and was denied or not given as much credit as requested"
label define  hcred12deniednl  1 "Yes" 2 "No"
label values  hcred12denied "hcred12deniednl"
label variable hcred12deniedc "Denied or not given as much credit as requested, among households that had applied for credit card or personal loan or line of credit from bank in past 12 months"
label define  hcred12deniedcnl  1 "Yes" 2 "No" -1 "NIU"
label values  hcred12deniedc "hcred12deniedcnl"
label variable hcred12discour "Did not apply for credit card or personal loan or line of credit from bank in past 12 months because of concerns about being turned down"
label define  hcred12discournl  1 "Yes" 2 "No"
label values  hcred12discour "hcred12discournl"
label variable hcred12grps "Bank and nonbank credit product use"
label define  hcred12grpsnl  1 "Bank credit only" 2 "Bank and nonbank credit" 3 "Nonbank credit only" 4 "No credit"
label values  hcred12grps "hcred12grpsnl"
label variable hsav12 "Saved for unexpected expenses or emergencies in past 12 months"
label define  hsav12nl  1 "Yes" 2 "No"
label values  hsav12 "hsav12nl"
label variable hsav12typ1 "Saved: Kept savings in checking account"
label define  hsav12typ1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ1 "hsav12typ1nl"
label variable hsav12typ2 "Saved: Kept savings in savings account"
label define  hsav12typ2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ2 "hsav12typ2nl"
label variable hsav12typ3 "Saved: Kept savings on prepaid card"
label define  hsav12typ3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ3 "hsav12typ3nl"
label variable hsav12typ4 "Saved: Kept savings in other accounts"
label define  hsav12typ4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ4 "hsav12typ4nl"
label variable hsav12typ5 "Saved: Kept savings in home, or with family or friends"
label define  hsav12typ5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ5 "hsav12typ5nl"
label variable hsav12typ6 "Saved: Bought something with intent to pawn or sell later"
label define  hsav12typ6nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ6 "hsav12typ6nl"
label variable hsav12typ7 "Saved: Other method"
label define  hsav12typ7nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ7 "hsav12typ7nl"
label variable hsav12typ99 "Saved: Unknown method"
label define  hsav12typ99nl  1 "Yes" 2 "No" -1 "NIU"
label values  hsav12typ99 "hsav12typ99nl"
label variable hincvol "Monthly income volatility"
label define  hincvolnl  1 "Income was about the same each month" 2 "Income varied somewhat from month to month" 3 "Income varied a lot from month to month"
label values  hincvol "hincvolnl"
label variable hincvolv2 "Monthly income volatility (less detail)"
label define  hincvolv2nl  1 "Income was about the same each month" 2 "Income varied somewhat or a lot from month to month"
label values  hincvolv2 "hincvolv2nl"
label variable hbilldq "Fell behind on bills in past 12 months"
label define  hbilldqnl  1 "Yes" 2 "No"
label values  hbilldq "hbilldqnl"
label variable hfinfobnk "Asked bank teller or customer service agent about finances in past 12 months"
label define  hfinfobnknl  1 "Yes" 2 "No"
label values  hfinfobnk "hfinfobnknl"
label variable hfinedu "Attended financial education classes or counseling sessions in past 12 months"
label define  hfinedunl  1 "Yes" 2 "No"
label values  hfinedu "hfinedunl"
label variable hfinedbnk "Learned about financial education classes or counseling sessions from bank"
label define  hfinedbnknl  1 "Yes" 2 "No" -1 "NIU"
label values  hfinedbnk "hfinedbnknl"
label variable hintaccv2 "Home internet access"
label define  hintaccv2nl  1 "Has access" 2 "Does not have access"
label values  hintaccv2 "hintaccv2nl"
label variable huse12afst "Used nonbank transaction product in past 12 months"
label define  huse12afstnl  1 "Yes" 2 "No" 99 "Unknown"
label values  huse12afst "huse12afstnl"
label variable huse12afsc "Used nonbank credit product in past 12 months"
label define  huse12afscnl  1 "Yes" 2 "No"
label values  huse12afsc "huse12afscnl"
label variable huse12afs "Used nonbank transaction or credit product in past 12 months"
label define  huse12afsnl  1 "Yes" 2 "No"
label values  huse12afs "huse12afsnl"
label variable huse12afsnbr "Number of nonbank transaction and credit products used"
label define  huse12afsnbrnl  0 "Did not use" 1 "Used 1" 2 "Used 2" 3 "Used 3 or more"
label values  huse12afsnbr "huse12afsnbrnl"
label variable huse12afstype "Type of nonbank transaction and credit products used in past 12 months"
label define  huse12afstypenl  1 "Nonbank transaction only" 2 "Nonbank transaction and credit" 3 "Nonbank credit only" 4 "Did not use"
label values  huse12afstype "huse12afstypenl"
label variable hinutyp "In universe, transactions in typical month (2015 sample selection)"
label define  hinutypnl  1 "Yes" 2 "No"
label values  hinutyp "hinutypnl"
label variable hinutypv2 "In universe, transactions in typical month (2017 sample selection)"
label define  hinutypv2nl  1 "Yes" 2 "No"
label values  hinutypv2 "hinutypv2nl"
label variable hinucred "In universe, bank credit"
label define  hinucrednl  1 "Yes" 2 "No"
label values  hinucred "hinucrednl"
label variable hinunbcred "In universe, nonbank credit"
label define  hinunbcrednl  1 "Yes" 2 "No"
label values  hinunbcred "hinunbcrednl"
label variable hinuec "In universe, measuring economic inclusion"
label define  hinuecnl  1 "Yes" 2 "No"
label values  hinuec "hinuecnl"
label variable hinulearn "In universe, learning about finances"
label define  hinulearnnl  1 "Yes" 2 "No"
label values  hinulearn "hinulearnnl"
label variable hbnkbrgo "Visited bank branch in past 12 months"
label define  hbnkbrgonl  1 "Yes" 2 "No"
label values  hbnkbrgo "hbnkbrgonl"
label variable hbnkbrgofq "Number of bank branch visits in past 12 months"
label define  hbnkbrgofqnl  1 "1 to 4 times" 2 "5 to 9 times" 3 "10 or more times" 5 "Did not visit bank branch in past 12 months"
label values  hbnkbrgofq "hbnkbrgofqnl"
label variable hbnkbrgofq_c "Number of bank branch visits in past 12 months (conditional on visiting bank branch)"
label define  hbnkbrgofq_cnl  1 "1 to 4 times" 2 "5 to 9 times" 3 "10 or more times" -1 "NIU"
label values  hbnkbrgofq_c "hbnkbrgofq_cnl"
label variable hbnkbrgounb "Unbanked households: Visited bank branch in past 12 months"
label define  hbnkbrgounbnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkbrgounb "hbnkbrgounbnl"
label variable hbnkmobv2a "Mobile activity: Checked email from bank about account"
label define  hbnkmobv2anl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2a "hbnkmobv2anl"
label variable hbnkmobv2b "Mobile activity: Received mobile text alert or push notification from bank about account"
label define  hbnkmobv2bnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2b "hbnkmobv2bnl"
label variable hbnkmobv2c "Mobile activity: Checked bank account balance or recent transactions"
label define  hbnkmobv2cnl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmobv2c "hbnkmobv2cnl"
label variable hbnkmobv2d "Mobile activity: Made bill payment"
label define  hbnkmobv2dnl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmobv2d "hbnkmobv2dnl"
label variable hbnkmobv2e "Mobile activity: Sent money to other people"
label define  hbnkmobv2enl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmobv2e "hbnkmobv2enl"
label variable hbnkmobv2f "Mobile activity: Transferred money between bank accounts owned by same person"
label define  hbnkmobv2fnl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmobv2f "hbnkmobv2fnl"
label variable hbnkmobv2g "Mobile activity: Deposited check into bank account"
label define  hbnkmobv2gnl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmobv2g "hbnkmobv2gnl"
label variable hbnkmobv2a_c "Mobile activity: Checked email from bank about account (conditional on using mobile banking)"
label define  hbnkmobv2a_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2a_c "hbnkmobv2a_cnl"
label variable hbnkmobv2b_c "Mobile activity: Received mobile text alert or push notification from bank about account (conditional on using mobile banking)"
label define  hbnkmobv2b_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2b_c "hbnkmobv2b_cnl"
label variable hbnkmobv2c_c "Mobile activity: Checked bank account balance or recent transactions (conditional on using mobile banking)"
label define  hbnkmobv2c_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2c_c "hbnkmobv2c_cnl"
label variable hbnkmobv2d_c "Mobile activity: Made bill payment (conditional on using mobile banking)"
label define  hbnkmobv2d_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2d_c "hbnkmobv2d_cnl"
label variable hbnkmobv2e_c "Mobile activity: Sent money to other people (conditional on using mobile banking)"
label define  hbnkmobv2e_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2e_c "hbnkmobv2e_cnl"
label variable hbnkmobv2f_c "Mobile activity: Transferred money between bank accounts owned by same person (conditional on using mobile banking)"
label define  hbnkmobv2f_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2f_c "hbnkmobv2f_cnl"
label variable hbnkmobv2g_c "Mobile activity: Deposited check into bank account (conditional on using mobile banking)"
label define  hbnkmobv2g_cnl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkmobv2g_c "hbnkmobv2g_cnl"
label variable huse12oafsc "Took out other types of loans or lines of credit from payday lender, auto title lender, pawn shop, or check casher in past 12 months"
label define  huse12oafscnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12oafsc "huse12oafscnl"
label variable hcred12sc "Had store credit card in past 12 months"
label define  hcred12scnl  1 "Yes" 2 "No"
label values  hcred12sc "hcred12scnl"
label variable hcred12car "Had auto loan in past 12 months"
label define  hcred12carnl  1 "Yes" 2 "No"
label values  hcred12car "hcred12carnl"
label variable hcred12hmln "Had mortgage, home equity loan, or home equity line of credit in past 12 months"
label define  hcred12hmlnnl  1 "Yes" 2 "No"
label values  hcred12hmln "hcred12hmlnnl"
label variable hcred12sl "Had student loan in past 12 months"
label define  hcred12slnl  1 "Yes" 2 "No"
label values  hcred12sl "hcred12slnl"
label variable hcred12oth "Had other personal loans or lines of credit from company other than bank in past 12 months"
label define  hcred12othnl  1 "Yes" 2 "No"
label values  hcred12oth "hcred12othnl"
label variable hcred12any "Used mainstream credit in past 12 months"
label define  hcred12anynl  1 "Yes" 2 "No"
label values  hcred12any "hcred12anynl"
label variable hcred12none "Did not use mainstream credit in past 12 months"
label define  hcred12nonenl  1 "Yes" 2 "No"
label values  hcred12none "hcred12nonenl"
label variable hbankstatv4 "Unbanked and underbanked"
label define  hbankstatv4nl  1 "Unbanked" 2 "Banked: Underbanked" 3 "Banked: Fully banked"
label values  hbankstatv4 "hbankstatv4nl"
label variable huse12afscv2 "Used nonbank credit product in past 12 months"
label define  huse12afscv2nl  1 "Yes" 2 "No"
label values  huse12afscv2 "huse12afscv2nl"
label variable huse12afsv2 "Used nonbank credit or transaction product in past 12 months"
label define  huse12afsv2nl  1 "Yes" 2 "No"
label values  huse12afsv2 "huse12afsv2nl"
label variable huse12afsnbrv2 "Number of nonbank transaction and credit products used"
label define  huse12afsnbrv2nl  0 "Did not use" 1 "Used 1" 2 "Used 2" 3 "Used 3 or more"
label values  huse12afsnbrv2 "huse12afsnbrv2nl"
label variable huse12afstypev2 "Type of nonbank transaction and credit products used in past 12 months"
label define  huse12afstypev2nl  1 "Nonbank transaction only" 2 "Nonbank transaction and credit" 3 "Nonbank credit only" 4 "Did not use"
label values  huse12afstypev2 "huse12afstypev2nl"
label variable htypincchkmov2 "Typical income: Paper check or money order"
label define  htypincchkmov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincchkmov2 "htypincchkmov2nl"
label variable htypincddbnkv2 "Typical income: Direct deposit or electronic transfer into bank account"
label define  htypincddbnkv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincddbnkv2 "htypincddbnkv2nl"
label variable htypincddppv2 "Typical income: Direct deposit or electronic transfer onto prepaid card"
label define  htypincddppv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincddppv2 "htypincddppv2nl"
label variable htypinccashv2 "Typical income: Cash"
label define  htypinccashv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypinccashv2 "htypinccashv2nl"
label variable htypincothv2 "Typical income: Other"
label define  htypincothv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincothv2 "htypincothv2nl"
label variable htypincccv2 "Typical income: Used nonbank check casher"
label define  htypincccv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincccv2 "htypincccv2nl"
label variable htypincnonev2 "Typical income: None selected"
label define  htypincnonev2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincnonev2 "htypincnonev2nl"
label variable htypincbnkav2 "Typical income: Any bank method"
label define  htypincbnkav2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincbnkav2 "htypincbnkav2nl"
label variable htypincbnkov2 "Typical income: Only bank methods"
label define  htypincbnkov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypincbnkov2 "htypincbnkov2nl"
label variable htyppaycashv2 "Typical billpay: Cash"
label define  htyppaycashv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaycashv2 "htyppaycashv2nl"
label variable htyppaybnkchkv2 "Typical billpay: Personal check"
label define  htyppaybnkchkv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkchkv2 "htyppaybnkchkv2nl"
label variable htyppaybnkdcv2 "Typical billpay: Debit card"
label define  htyppaybnkdcv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkdcv2 "htyppaybnkdcv2nl"
label variable htyppayccv2 "Typical billpay: Credit card"
label define  htyppayccv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppayccv2 "htyppayccv2nl"
label variable htyppayppv2 "Typical billpay: Prepaid card"
label define  htyppayppv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppayppv2 "htyppayppv2nl"
label variable htyppaybnkbpv2 "Typical billpay: Electronic payment from bank account"
label define  htyppaybnkbpv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkbpv2 "htyppaybnkbpv2nl"
label variable htyppaynbnkmov2 "Typical billpay: Nonbank money order"
label define  htyppaynbnkmov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaynbnkmov2 "htyppaynbnkmov2nl"
label variable htyppaybnkmov2 "Typical billpay: Bank money order or cashiers check"
label define  htyppaybnkmov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkmov2 "htyppaybnkmov2nl"
label variable htyppayothv2 "Typical billpay: Other"
label define  htyppayothv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppayothv2 "htyppayothv2nl"
label variable htyppaynonev2 "Typical billpay: None selected"
label define  htyppaynonev2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaynonev2 "htyppaynonev2nl"
label variable htyppaybnkav2 "Typical billpay: Any bank method"
label define  htyppaybnkav2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkav2 "htyppaybnkav2nl"
label variable htyppaybnkov2 "Typical billpay: Only bank methods"
label define  htyppaybnkov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htyppaybnkov2 "htyppaybnkov2nl"
label variable htypbnkov2 "Typical billpay and income receipt: Only bank methods"
label define  htypbnkov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  htypbnkov2 "htypbnkov2nl"
label variable hbnkmob1bnk "Mobile activity: Downloaded or used bank mobile app"
label define  hbnkmob1bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob1bnk "hbnkmob1bnknl"
label variable hbnkmob2bnk "Mobile activity: Checked bank account balance or recent transactions"
label define  hbnkmob2bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob2bnk "hbnkmob2bnknl"
label variable hbnkmob3bnk "Mobile activity: Made bill payment"
label define  hbnkmob3bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob3bnk "hbnkmob3bnknl"
label variable hbnkmob4bnk "Mobile activity: Read text message alert from bank"
label define  hbnkmob4bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob4bnk "hbnkmob4bnknl"
label variable hbnkmob5bnk "Mobile activity: Sent money to other people"
label define  hbnkmob5bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob5bnk "hbnkmob5bnknl"
label variable hbnkmob6bnk "Mobile activity: Transferred money between accounts owned by same person"
label define  hbnkmob6bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob6bnk "hbnkmob6bnknl"
label variable hbnkmob7bnk "Mobile activity: Deposited check electronically"
label define  hbnkmob7bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob7bnk "hbnkmob7bnknl"
label variable hbnkmob8bnk "Mobile activity: Located closest in-network ATM or bank branch"
label define  hbnkmob8bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob8bnk "hbnkmob8bnknl"
label variable hbnkmob9bnk "Mobile activity: Other"
label define  hbnkmob9bnknl  1 "Yes" 2 "No" 99 "Unknown" -1 "NIU"
label values  hbnkmob9bnk "hbnkmob9bnknl"
label variable hcred12int "Applied for credit card or personal loan or line of credit from bank, did not apply because of concerns about being turned down, or used nonbank credit product in past 12 months"
label define  hcred12intnl  1 "Yes" 2 "No"
label values  hcred12int "hcred12intnl"
label variable hcred12undem "Had unmet demand for mainstream small-dollar credit in past 12 months"
label define  hcred12undemnl  1 "Yes" 2 "No"
label values  hcred12undem "hcred12undemnl"
label variable htypbnkound "Underbanked households: use of bank methods to pay bills and receive income in a typical month"
label define  htypbnkoundnl  1 "Used only bank methods to pay bills and receive income" 2 "Did not exclusively use bank methods to pay bills and receive income" -1 "NIU"
label values  htypbnkound "htypbnkoundnl"
label variable gtmetsta "Metropolitan and nonmetropolitan status"
label define  gtmetstanl  1 "Metropolitan area" 2 "Not in metropolitan area" 3 "Not identified"
label values  gtmetsta "gtmetstanl"
label variable gtmetsta5yr03 "Metropolitan and nonmetropolitan status"
label define  gtmetsta5yr03nl  1 "Metropolitan area" 2 "Not in metropolitan area" 3 "Not identified"
label values  gtmetsta5yr03 "gtmetsta5yr03nl"
label variable gtmetsta5yr13 "Metropolitan and nonmetropolitan status"
label define  gtmetsta5yr13nl  1 "Metropolitan area" 2 "Not in metropolitan area" 3 "Not identified"
label values  gtmetsta5yr13 "gtmetsta5yr13nl"
label variable hbnkprevv2 "Previously banked"
label define  hbnkprevv2nl  1 "Once had bank account" 2 "Never had bank account" -1 "NIU"
label values  hbnkprevv2 "hbnkprevv2nl"
label variable hbnkfutrv2 "Likelihood of opening account"
label define  hbnkfutrv2nl  1 "Very likely" 2 "Somewhat likely" 3 "Not very likely" 4 "Not at all likely" -1 "NIU"
label values  hbnkfutrv2 "hbnkfutrv2nl"
label variable hbnkprevlyv2 "Previously banked (within last year)"
label define  hbnkprevlyv2nl  1 "Had bank account within last year" 2 "Had bank account more than 1 year ago" 3 "Never had bank account" -1 "NIU" 98 "Previously banked, recency unknown"
label values  hbnkprevlyv2 "hbnkprevlyv2nl"
label variable hbnkprevlyv3 "Previously banked (within last year)"
label define  hbnkprevlyv3nl  1 "Had bank account within last year" 2 "Had bank account more than 1 year ago" 3 "Never had bank account" -1 "NIU"
label values  hbnkprevlyv3 "hbnkprevlyv3nl"
label variable praceeth3 "Race/Ethnicity"
label define  praceeth3nl  1 "Black" 2 "Hispanic" 3 "Asian" 4 "American Indian or Alaska Native" 5 "Native Hawaiian or Other Pacific Islander" 6 "White" 7 "Two or More Races"
label values  praceeth3 "praceeth3nl"
label variable hinuphoneint "In universe, mobile phone, smartphone, and home internet access"
label define  hinuphoneintnl  1 "Yes" 2 "No"
label values  hinuphoneint "hinuphoneintnl"
label variable hbnkint "Interest in having bank account"
label define  hbnkintnl  1 "Very interested" 2 "Somewhat interested" 3 "Not very interested" 4 "Not at all interested" -1 "NIU"
label values  hbnkint "hbnkintnl"
label variable hunbnkr1v4 "Why unbanked: Bank hours are inconvenient"
label define  hunbnkr1v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr1v4 "hunbnkr1v4nl"
label variable hunbnkr2v4 "Why unbanked: Bank locations are inconvenient"
label define  hunbnkr2v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr2v4 "hunbnkr2v4nl"
label variable hunbnkr3v4 "Why unbanked: Bank account fees are too high"
label define  hunbnkr3v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr3v4 "hunbnkr3v4nl"
label variable hunbnkr4v4 "Why unbanked: Bank account fees are too unpredictable"
label define  hunbnkr4v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr4v4 "hunbnkr4v4nl"
label variable hunbnkr5v4 "Why unbanked: Banks do not offer needed products and services"
label define  hunbnkr5v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr5v4 "hunbnkr5v4nl"
label variable hunbnkr6v4 "Why unbanked: Do not trust banks"
label define  hunbnkr6v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr6v4 "hunbnkr6v4nl"
label variable hunbnkr7v4 "Why unbanked: Do not have enough money to meet minimum balance requirements"
label define  hunbnkr7v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr7v4 "hunbnkr7v4nl"
label variable hunbnkr8v4 "Why unbanked: Avoiding a bank gives more privacy"
label define  hunbnkr8v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr8v4 "hunbnkr8v4nl"
label variable hunbnkr9v4 "Why unbanked: Personal identification, credit, or former bank account problems"
label define  hunbnkr9v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr9v4 "hunbnkr9v4nl"
label variable hunbnkr10v4 "Why unbanked: Other reason"
label define  hunbnkr10v4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr10v4 "hunbnkr10v4nl"
label variable hunbnkrnonev4 "Why unbanked: Did not select a reason"
label define  hunbnkrnonev4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkrnonev4 "hunbnkrnonev4nl"
label variable hunbnkrmv4 "Main reason unbanked"
label define  hunbnkrmv4nl  1 "Bank hours are inconvenient" 2 "Bank locations are inconvenient" 3 "Bank account fees are too high" 4 "Bank account fees are too unpredictable" 5 "Banks do not offer needed products and services" 6 "Do not trust banks" 7 "Do not have enough money to meet minimum balance requirements" 8 "Avoiding a bank gives more privacy" 9 "Personal identification, credit, or former bank account problems" 10 "Other reason" 98 "Did not select a reason" -1 "NIU"
label values  hunbnkrmv4 "hunbnkrmv4nl"
label variable hppwhere1v2 "Prepaid card, where from: Employer to pay salary or wages"
label define  hppwhere1v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere1v2 "hppwhere1v2nl"
label variable hppwhere2v2 "Prepaid card, where from: Government agency"
label define  hppwhere2v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere2v2 "hppwhere2v2nl"
label variable hppwhere3v2 "Prepaid card, where from: Place or website that is not a bank"
label define  hppwhere3v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere3v2 "hppwhere3v2nl"
label variable hppwhere4v2 "Prepaid card, where from: Bank branch or bank website"
label define  hppwhere4v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hppwhere4v2 "hppwhere4v2nl"
label variable hppbankstill "Still use prepaid card from bank branch or bank website"
label define  hppbankstillnl  1 "Yes" 2 "No" -1 "NIU"
label values  hppbankstill "hppbankstillnl"
label variable hbnkaccm1v2 "Bank account access: Bank teller"
label define  hbnkaccm1v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm1v2 "hbnkaccm1v2nl"
label variable hbnkaccm2v2 "Bank account access: ATM/Kiosk"
label define  hbnkaccm2v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm2v2 "hbnkaccm2v2nl"
label variable hbnkaccm3v2 "Bank account access: Telephone banking"
label define  hbnkaccm3v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm3v2 "hbnkaccm3v2nl"
label variable hbnkaccm4v2 "Bank account access: Online banking"
label define  hbnkaccm4v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm4v2 "hbnkaccm4v2nl"
label variable hbnkaccm5v2 "Bank account access: Mobile banking"
label define  hbnkaccm5v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm5v2 "hbnkaccm5v2nl"
label variable hbnkaccm6v2 "Bank account access: Other"
label define  hbnkaccm6v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm6v2 "hbnkaccm6v2nl"
label variable hbnkaccm7v2 "Bank account access: Did not access in past 12 months"
label define  hbnkaccm7v2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hbnkaccm7v2 "hbnkaccm7v2nl"
label variable hbnkaccmnbrv2 "Number of banking access methods"
label define  hbnkaccmnbrv2nl  0 "Did not access account in past 12 months" 1 "1 method" 2 "2 or more methods" -1 "NIU"
label values  hbnkaccmnbrv2 "hbnkaccmnbrv2nl"
label variable hbranchstatv2 "Bank account access: Use of bank teller and other methods"
label define  hbranchstatv2nl  1 "Used bank teller only" 2 "Used bank teller and other methods" 3 "Did not use bank teller but used other methods" -1 "NIU"
label values  hbranchstatv2 "hbranchstatv2nl"
label variable hbranchatmstatv2 "Bank account access: Use of physical channels and other methods"
label define  hbranchatmstatv2nl  1 "Used physical channels only" 2 "Used physical channels and other methods" 3 "Did not use physical channels but used other methods" -1 "NIU"
label values  hbranchatmstatv2 "hbranchatmstatv2nl"
label variable huse12p2p "Used nonbank person-to-person or peer-to-peer (P2P) payment service in past 12 months"
label define  huse12p2pnl  1 "Yes" 2 "No"
label values  huse12p2p "huse12p2pnl"
label variable huse12bp "Used nonbank bill payment service in past 12 months"
label define  huse12bpnl  1 "Yes" 2 "No"
label values  huse12bp "huse12bpnl"
label variable hfreqmo "Frequency of nonbank money order use in past 12 months"
label define  hfreqmonl  1 "Often" 2 "Sometimes" 3 "Rarely" 4 "Did not use"
label values  hfreqmo "hfreqmonl"
label variable hfreqcc "Frequency of nonbank check cashing use in past 12 months"
label define  hfreqccnl  1 "Often" 2 "Sometimes" 3 "Rarely" 4 "Did not use"
label values  hfreqcc "hfreqccnl"
label variable hfreqrm "Frequency of nonbank international remittance use in past 12 months"
label define  hfreqrmnl  1 "Often" 2 "Sometimes" 3 "Rarely" 4 "Did not use"
label values  hfreqrm "hfreqrmnl"
label variable hfreqbp "Frequency of nonbank bill payment service use in past 12 months"
label define  hfreqbpnl  1 "Often" 2 "Sometimes" 3 "Rarely" 4 "Did not use"
label values  hfreqbp "hfreqbpnl"
label variable huse12nbtrans "Used nonbank check cashing, money order, international remittance, bill payment service, or person-to-person or peer-to-peer (P2P) payment service in past 12 months"
label define  huse12nbtransnl  1 "Yes" 2 "No"
label values  huse12nbtrans "huse12nbtransnl"
label variable huse12moccbp "Used nonbank check cashing, money order, or bill payment service in past 12 months"
label define  huse12moccbpnl  1 "Yes" 2 "No"
label values  huse12moccbp "huse12moccbpnl"
label variable hfreqmobill "Use of nonbank money orders to pay bills in past 12 months"
label define  hfreqmobillnl  1 "Used money orders often to pay bills" 2 "Used money orders sometimes to pay bills" 3 "Used money orders often but not to pay bills" 4 "Used money orders sometimes but not to pay bills" 5 "Used money orders rarely (bill payment use unknown)" 6 "Did not use money orders"
label values  hfreqmobill "hfreqmobillnl"
label variable hbnksatisbnk "Banked households: Satisfaction with primary bank"
label define  hbnksatisbnknl  1 "Very satisfied" 2 "Somewhat satisfied" 3 "Not very satisfied" 4 "Not satisfied at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnksatisbnk "hbnksatisbnknl"
label variable hbnksatisunbnk "Unbanked households: Satisfaction with most recent bank"
label define  hbnksatisunbnknl  1 "Very satisfied" 2 "Somewhat satisfied" 3 "Not very satisfied" 4 "Not satisfied at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnksatisunbnk "hbnksatisunbnknl"
label variable hbnkfeebnk "Banked households: Clarity of own bank communication about account fees"
label define  hbnkfeebnknl  1 "Very clearly" 2 "Somewhat clearly" 3 "Not very clearly" 4 "Not clearly at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnkfeebnk "hbnkfeebnknl"
label variable hbnkfeeunbnk "Unbanked households: Clarity of bank communications about account fees"
label define  hbnkfeeunbnknl  1 "Very clearly" 2 "Somewhat clearly" 3 "Not very clearly" 4 "Not clearly at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnkfeeunbnk "hbnkfeeunbnknl"
label variable hbnksatisbnkv2 "Banked households: Satisfaction with primary bank (less detail)"
label define  hbnksatisbnkv2nl  1 "Very or somewhat satisfied" 2 "Not very satisfied or not satisfied at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnksatisbnkv2 "hbnksatisbnkv2nl"
label variable hbnksatisunbnkv2 "Unbanked households: Satisfaction with most recent bank (less detail)"
label define  hbnksatisunbnkv2nl  1 "Very or somewhat satisfied" 2 "Not very satisfied or not satisfied at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnksatisunbnkv2 "hbnksatisunbnkv2nl"
label variable hbnkfeebnkv2 "Banked households: Clarity of own bank communication about account fees (less detail)"
label define  hbnkfeebnkv2nl  1 "Very or somewhat clearly" 2 "Not very clearly or not clearly at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnkfeebnkv2 "hbnkfeebnkv2nl"
label variable hbnkfeeunbnkv2 "Unbanked households: Clarity of bank communications about account fees (less detail)"
label define  hbnkfeeunbnkv2nl  1 "Very or somewhat clearly" 2 "Not very clearly or not clearly at all" 98 "Unknown: Do not know" -1 "NIU"
label values  hbnkfeeunbnkv2 "hbnkfeeunbnkv2nl"
label variable hcred12ccorbnkv2 "Used bank credit product in past 12 months"
label define  hcred12ccorbnkv2nl  1 "Yes" 2 "No"
label values  hcred12ccorbnkv2 "hcred12ccorbnkv2nl"
label variable hunbnkr1v5 "Why unbanked: Bank locations are inconvenient"
label define  hunbnkr1v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr1v5 "hunbnkr1v5nl"
label variable hunbnkr2v5 "Why unbanked: Bank account fees are too high"
label define  hunbnkr2v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr2v5 "hunbnkr2v5nl"
label variable hunbnkr3v5 "Why unbanked: Bank account fees are too unpredictable"
label define  hunbnkr3v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr3v5 "hunbnkr3v5nl"
label variable hunbnkr4v5 "Why unbanked: Banks do not offer needed products and services"
label define  hunbnkr4v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr4v5 "hunbnkr4v5nl"
label variable hunbnkr5v5 "Why unbanked: Do not trust banks"
label define  hunbnkr5v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr5v5 "hunbnkr5v5nl"
label variable hunbnkr6v5 "Why unbanked: Do not have enough money to meet minimum balance requirements"
label define  hunbnkr6v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr6v5 "hunbnkr6v5nl"
label variable hunbnkr7v5 "Why unbanked: Avoiding a bank gives more privacy"
label define  hunbnkr7v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr7v5 "hunbnkr7v5nl"
label variable hunbnkr8v5 "Why unbanked: Do not have personal identification required to open an account"
label define  hunbnkr8v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr8v5 "hunbnkr8v5nl"
label variable hunbnkr9v5 "Why unbanked: Problems with past banking or credit history"
label define  hunbnkr9v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr9v5 "hunbnkr9v5nl"
label variable hunbnkr10v5 "Why unbanked: Other reason"
label define  hunbnkr10v5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkr10v5 "hunbnkr10v5nl"
label variable hunbnkrnonev5 "Why unbanked: Did not select a reason"
label define  hunbnkrnonev5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hunbnkrnonev5 "hunbnkrnonev5nl"
label variable hunbnkrmv5 "Main reason unbanked"
label define  hunbnkrmv5nl  1 "Bank locations are inconvenient" 2 "Bank account fees are too high" 3 "Bank account fees are too unpredictable" 4 "Banks do not offer needed products and services" 5 "Do not trust banks" 6 "Do not have enough money to meet minimum balance requirements" 7 "Avoiding a bank gives more privacy" 8 "Do not have personal identification required to open an account" 9 "Problems with past banking or credit history" 10 "Other reason" 98 "Did not select a reason" -1 "NIU"
label values  hunbnkrmv5 "hunbnkrmv5nl"
label variable husenowops "Used nonbank online payment service"
label define  husenowopsnl  1 "Yes" 2 "No"
label values  husenowops "husenowopsnl"
label variable husenowpp "Used prepaid card"
label define  husenowppnl  1 "Yes" 2 "No"
label values  husenowpp "husenowppnl"
label variable huse12bnkrsna "Bank account transaction type in past 12 months: Build savings or keep money in safe place"
label define  huse12bnkrsnanl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsna "huse12bnkrsnanl"
label variable huse12bnkrsnb "Bank account transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care"
label define  huse12bnkrsnbnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnb "huse12bnkrsnbnl"
label variable huse12bnkrsnc "Bank account transaction type in past 12 months: Receive money from work, retirement, or government agency"
label define  huse12bnkrsncnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnc "huse12bnkrsncnl"
label variable huse12bnkrsnd "Bank account transaction type in past 12 months: Send or receive money from family or friends"
label define  huse12bnkrsndnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnd "huse12bnkrsndnl"
label variable huse12bnkrsne "Bank account transaction type in past 12 months: Make purchases in person"
label define  huse12bnkrsnenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsne "huse12bnkrsnenl"
label variable huse12bnkrsnf "Bank account transaction type in past 12 months: Make purchases online"
label define  huse12bnkrsnfnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnf "huse12bnkrsnfnl"
label variable huse12bnkrsng "Bank account transaction type in past 12 months: Some other use"
label define  huse12bnkrsngnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsng "huse12bnkrsngnl"
label variable huse12bnkrsnnone "Bank account transaction type in past 12 months: None selected"
label define  huse12bnkrsnnonenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnnone "huse12bnkrsnnonenl"
label variable huse12bnkrsnbc "Bank account transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care or receive money from work, retirement, or government agency"
label define  huse12bnkrsnbcnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12bnkrsnbc "huse12bnkrsnbcnl"
label variable huse12opsrsna "Nonbank online payment service transaction type in past 12 months: Build savings or keep money in safe place"
label define  huse12opsrsnanl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsna "huse12opsrsnanl"
label variable huse12opsrsnb "Nonbank online payment service transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care"
label define  huse12opsrsnbnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnb "huse12opsrsnbnl"
label variable huse12opsrsnc "Nonbank online payment service transaction type in past 12 months: Receive money from work, retirement, or government agency"
label define  huse12opsrsncnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnc "huse12opsrsncnl"
label variable huse12opsrsnd "Nonbank online payment service transaction type in past 12 months: Send or receive money from family or friends"
label define  huse12opsrsndnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnd "huse12opsrsndnl"
label variable huse12opsrsne "Nonbank online payment service transaction type in past 12 months: Make purchases in person"
label define  huse12opsrsnenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsne "huse12opsrsnenl"
label variable huse12opsrsnf "Nonbank online payment service transaction type in past 12 months: Make purchases online"
label define  huse12opsrsnfnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnf "huse12opsrsnfnl"
label variable huse12opsrsng "Nonbank online payment service transaction type in past 12 months: Some other use"
label define  huse12opsrsngnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsng "huse12opsrsngnl"
label variable huse12opsrsnnone "Nonbank online payment service transaction type in past 12 months: None selected"
label define  huse12opsrsnnonenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnnone "huse12opsrsnnonenl"
label variable huse12opsrsnbc "Nonbank online payment service transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care or receive money from work, retirement, or government agency"
label define  huse12opsrsnbcnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12opsrsnbc "huse12opsrsnbcnl"
label variable huse12pprsna "Prepaid card transaction type in past 12 months: Build savings or keep money in safe place"
label define  huse12pprsnanl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsna "huse12pprsnanl"
label variable huse12pprsnb "Prepaid card transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care"
label define  huse12pprsnbnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnb "huse12pprsnbnl"
label variable huse12pprsnc "Prepaid card transaction type in past 12 months: Receive money from work, retirement, or government agency"
label define  huse12pprsncnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnc "huse12pprsncnl"
label variable huse12pprsnd "Prepaid card transaction type in past 12 months: Send or receive money from family or friends"
label define  huse12pprsndnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnd "huse12pprsndnl"
label variable huse12pprsne "Prepaid card transaction type in past 12 months: Make purchases in person"
label define  huse12pprsnenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsne "huse12pprsnenl"
label variable huse12pprsnf "Prepaid card transaction type in past 12 months: Make purchases online"
label define  huse12pprsnfnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnf "huse12pprsnfnl"
label variable huse12pprsng "Prepaid card transaction type in past 12 months: Some other use"
label define  huse12pprsngnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsng "huse12pprsngnl"
label variable huse12pprsnnone "Prepaid card transaction type in past 12 months: None selected"
label define  huse12pprsnnonenl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnnone "huse12pprsnnonenl"
label variable huse12pprsnbc "Prepaid card transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care or receive money from work, retirement, or government agency"
label define  huse12pprsnbcnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12pprsnbc "huse12pprsnbcnl"
label variable hopslink1 "Account linked to nonbank online payment service: Credit card"
label define  hopslink1nl  1 "Yes" 2 "No" -1 "NIU"
label values  hopslink1 "hopslink1nl"
label variable hopslink2 "Account linked to nonbank online payment service: Bank account"
label define  hopslink2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hopslink2 "hopslink2nl"
label variable hopslink3 "Account linked to nonbank online payment service: Prepaid card"
label define  hopslink3nl  1 "Yes" 2 "No" -1 "NIU"
label values  hopslink3 "hopslink3nl"
label variable hopslink4 "Account linked to nonbank online payment service: Other account"
label define  hopslink4nl  1 "Yes" 2 "No" -1 "NIU"
label values  hopslink4 "hopslink4nl"
label variable hopslink5 "Account linked to nonbank online payment service: Not linked to any accounts"
label define  hopslink5nl  1 "Yes" 2 "No" -1 "NIU"
label values  hopslink5 "hopslink5nl"
label variable huse12morsn1 "Nonbank money order transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care"
label define  huse12morsn1nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12morsn1 "huse12morsn1nl"
label variable huse12morsn2 "Nonbank money order transaction type in past 12 months: Send money to family or friends"
label define  huse12morsn2nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12morsn2 "huse12morsn2nl"
label variable huse12morsn3 "Nonbank money order transaction type in past 12 months: Make purchases"
label define  huse12morsn3nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12morsn3 "huse12morsn3nl"
label variable huse12morsn4 "Nonbank money order transaction type in past 12 months: Some other use"
label define  huse12morsn4nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12morsn4 "huse12morsn4nl"
label variable huse12mt "Used nonbank money transfer service in past 12 months"
label define  huse12mtnl  1 "Yes" 2 "No"
label values  huse12mt "huse12mtnl"
label variable huse12mtrsn1 "Nonbank money transfer service transaction type in past 12 months: Pay monthly bills like rent, mortgage, utilities, or child care"
label define  huse12mtrsn1nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12mtrsn1 "huse12mtrsn1nl"
label variable huse12mtrsn2 "Nonbank money transfer service transaction type in past 12 months: Send or receive money from family or friends in United States"
label define  huse12mtrsn2nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12mtrsn2 "huse12mtrsn2nl"
label variable huse12mtrsn3 "Nonbank money transfer service transaction type in past 12 months: Send or receive money from family or friends outside United States"
label define  huse12mtrsn3nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12mtrsn3 "huse12mtrsn3nl"
label variable huse12mtrsn4 "Nonbank money transfer service transaction type in past 12 months: Some other use"
label define  huse12mtrsn4nl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12mtrsn4 "huse12mtrsn4nl"
label variable huse12ccfrom "Nonbank check cashing transaction type in past 12 months: Cashed checks from work, retirement, or government agency"
label define  huse12ccfromnl  1 "Yes" 2 "No" -1 "NIU"
label values  huse12ccfrom "huse12ccfromnl"
label variable hbillincomemethod "Used bank account, nonbank online payment service, prepaid card, nonbank money order, nonbank money transfer service, or nonbank check cashing to pay monthly bills like rent, mortgage, utilities, or child care or to receive money from work, retirement, or government agency"
label define  hbillincomemethodnl  1 "Yes" 2 "No"
label values  hbillincomemethod "hbillincomemethodnl"
label variable hpurchasemethod "Used bank account, nonbank online payment service, prepaid card, or nonbank money order to make purchases"
label define  hpurchasemethodnl  1 "Yes" 2 "No"
label values  hpurchasemethod "hpurchasemethodnl"
label variable hsendmoneymethod "Used bank account, nonbank online payment service, prepaid card, nonbank money order, or nonbank money transfer service to send or receive money from family or friends"
label define  hsendmoneymethodnl  1 "Yes" 2 "No"
label values  hsendmoneymethod "hsendmoneymethodnl"
label variable hsavemethod "Used bank account, nonbank online payment service, or prepaid card to build savings or keep money in safe place"
label define  hsavemethodnl  1 "Yes" 2 "No"
label values  hsavemethod "hsavemethodnl"
label variable huse12rmv2 "Used international remittance through nonbank in past 12 months"
label define  huse12rmv2nl  1 "Yes" 2 "No"
label values  huse12rmv2 "huse12rmv2nl"
label variable huse12bpv2 "Used nonbank money transfer service to pay monthly bills like rent, mortgage, utilities, or child care in past 12 months"
label define  huse12bpv2nl  1 "Yes" 2 "No"
label values  huse12bpv2 "huse12bpv2nl"
label variable hbankstatv5 "Unbanked and underbanked"
label define  hbankstatv5nl  1 "Unbanked" 2 "Banked: Underbanked" 3 "Banked: Fully banked"
label values  hbankstatv5 "hbankstatv5nl"
label variable hbankstattype "Unbanked and underbanked, nonbank transactions and credit"
label define  hbankstattypenl  1 "Unbanked" 2 "Banked: Underbanked, nonbank transactions only" 3 "Banked: Underbanked, nonbank credit only" 4 "Banked: Underbanked, both nonbank transactions and credit" 5 "Banked: Fully banked"
label values  hbankstattype "hbankstattypenl"
label variable hcred12bnkamt "Dollar amount of most recent personal loan or line of credit from bank"
label define  hcred12bnkamtnl  1 "$1,000 or less" 2 "More than $1,000" -1 "NIU"
label values  hcred12bnkamt "hcred12bnkamtnl"
label variable hcred12nbnk "Had personal loan or line of credit from company other than bank in past 12 months"
label define  hcred12nbnknl  1 "Yes" 2 "No"
label values  hcred12nbnk "hcred12nbnknl"
label variable hcred12nbnkamt "Dollar amount of most recent personal loan or line of credit from company other than bank"
label define  hcred12nbnkamtnl  1 "$1,000 or less" 2 "More than $1,000" -1 "NIU"
label values  hcred12nbnkamt "hcred12nbnkamtnl"
label variable hbnknewv2 "Length of bank account ownership"
label define  hbnknewv2nl  1 "Became banked between March 2020 and June 2021" 2 "Banked prior to March 2020" -1 "NIU"
label values  hbnknewv2 "hbnknewv2nl"
label variable hbnktransv3 "Transitions in bank account ownership"
label define  hbnktransv3nl  1 "Longer-term unbanked" 2 "Recently unbanked" 3 "Recently banked" 4 "Longer-term banked"
label values  hbnktransv3 "hbnktransv3nl"
label variable hevent1v2 "HH event: Lost or quit job, furloughed, or reduced hours"
label define  hevent1v2nl  1 "Yes" 2 "No"
label values  hevent1v2 "hevent1v2nl"
label variable hevent2v2 "HH event: Started new job"
label define  hevent2v2nl  1 "Yes" 2 "No"
label values  hevent2v2 "hevent2v2nl"
label variable hevent3v2 "HH event: Had significant loss of income"
label define  hevent3v2nl  1 "Yes" 2 "No"
label values  hevent3v2 "hevent3v2nl"
label variable hevent4v2 "HH event: Had significant increase in income"
label define  hevent4v2nl  1 "Yes" 2 "No"
label values  hevent4v2 "hevent4v2nl"
label variable hevent5v2 "HH event: Received government benefit payment (e.g., unemployment benefits or Coronavirus stimulus payment)"
label define  hevent5v2nl  1 "Yes" 2 "No"
label values  hevent5v2 "hevent5v2nl"
label variable hevent1bcv2 "Event contributed to bank account closing: Lost or quit a job, furloughed, or reduced hours"
label define  hevent1bcv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent1bcv2 "hevent1bcv2nl"
label variable hevent3bcv2 "Event contributed to bank account closing: Had significant loss of income"
label define  hevent3bcv2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent3bcv2 "hevent3bcv2nl"
label variable hevent2bov2 "Event contributed to bank account opening: Started new job"
label define  hevent2bov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent2bov2 "hevent2bov2nl"
label variable hevent4bov2 "Event contributed to bank account opening: Had significant increase in income"
label define  hevent4bov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent4bov2 "hevent4bov2nl"
label variable hevent5bov2 "Event contributed to bank account opening: Received government benefit payment (e.g., unemployment benefits or Coronavirus stimulus payment)"
label define  hevent5bov2nl  1 "Yes" 2 "No" -1 "NIU"
label values  hevent5bov2 "hevent5bov2nl"
